/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.character;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.rep.character.ICharStore;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ITextStore;

public class CharStore
implements ICharStore {
    private final ITextStore backing;

    public CharStore() {
        this((ITextStore)new GapTextStore());
    }

    public CharStore(ITextStore backing) {
        if (backing == null) {
            throw new NullPointerException();
        }
        this.backing = backing;
    }

    public char get(int offset) {
        return this.backing.get(offset);
    }

    public String get(int offset, int length) {
        return this.backing.get(offset, length);
    }

    public int getLength() {
        return this.backing.getLength();
    }

    public void replace(int offset, int length, String text) {
        this.backing.replace(offset, length, text);
    }

    public void set(String text) {
        this.backing.set(text);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (!ICharStore.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ICharStore tgtChars = (ICharStore)tgtData;
        int len = this.getLength();
        if (tgtChars.getLength() != len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.get(i) != tgtChars.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

