/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep;

import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentRepSet
extends RepSet {
    private static final long serialVersionUID = -8663798306043557912L;

    public ConsistentRepSet() {
    }

    public ConsistentRepSet(Collection<? extends IRep> c) {
        super(c);
    }

    protected ConsistentRepSet(RepSet parent, SortedSet<IRep> backing, IRep fromRep, IRep toRep) {
        super(parent, backing, fromRep, toRep);
    }

    @Override
    protected RepSet createSubset(RepSet parent, SortedSet<IRep> backing, IRep fromRep, IRep toRep) {
        return new ConsistentRepSet(parent, backing, fromRep, toRep);
    }

    @Override
    public boolean add(IRep rep) {
        Iterator<IRep> i = rep.anteIterator();
        while (i.hasNext()) {
            if (this.supports(i.next())) continue;
            return false;
        }
        return super.add(rep);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IRep)) {
            return false;
        }
        IRep rep = (IRep)o;
        Iterator<IRep> i = this.repIterator();
        while (i.hasNext()) {
            if (!i.next().dependsOn(rep)) continue;
            return false;
        }
        return super.remove(rep);
    }

    @Override
    public Iterator<IRep> iterator() {
        return new ConsistentRepresentationSetIterator();
    }

    protected class ConsistentRepresentationSetIterator
    extends RepSet.RepresentationSetIterator {
        protected ConsistentRepresentationSetIterator() {
            super(ConsistentRepSet.this);
        }

        public void remove() {
            if (RepUtils.hasAnyDependents(this.last, ConsistentRepSet.this)) {
                throw new IllegalStateException("Can't remove representation");
            }
            super.remove();
        }
    }
}

