/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.ImmutableProperty;
import edu.mit.story.core.property.ImmutablePropertyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyModifyEvent {
    public List<ImmutablePropertyPair> mods;

    public PropertyModifyEvent(IProperty oldProp, IProperty newProp) {
        ArrayList<ImmutablePropertyPair> hidden = new ArrayList<ImmutablePropertyPair>(1);
        hidden.add(new ImmutablePropertyPair(oldProp, newProp));
        this.mods = Collections.unmodifiableList(hidden);
    }

    public PropertyModifyEvent(Collection<? extends IProperty> properties, boolean add) {
        ArrayList<ImmutablePropertyPair> hidden = new ArrayList<ImmutablePropertyPair>(1);
        for (IProperty iProperty : properties) {
            if (add) {
                hidden.add(new ImmutablePropertyPair(null, iProperty));
                continue;
            }
            hidden.add(new ImmutablePropertyPair(iProperty, null));
        }
        this.mods = Collections.unmodifiableList(hidden);
    }

    public PropertyModifyEvent(Collection<? extends Map.Entry<? extends IProperty, ? extends IProperty>> mods) {
        this.mods = ImmutableProperty.makeImmutableModificationList(mods);
    }
}

