/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.property.AbstractProperty;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.ImmutablePropertyPair;
import edu.mit.story.core.property.Property;
import edu.mit.story.core.util.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableProperty
extends AbstractProperty
implements Immutable {
    private final String key;
    private final String value;

    public ImmutableProperty(Map.Entry<String, String> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public ImmutableProperty(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (Property.isInvalidPart(key)) {
            throw new IllegalArgumentException(StoryMessages.MSG_InvalidPropertyString);
        }
        if (Property.isInvalidPart(value)) {
            throw new IllegalArgumentException(StoryMessages.MSG_InvalidPropertyString);
        }
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setKey(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public static ImmutableProperty makeImmutable(Map.Entry<String, String> property) {
        return property instanceof ImmutableProperty ? (ImmutableProperty)property : new ImmutableProperty(property);
    }

    public static List<ImmutableProperty> makeImmutableList(Collection<? extends Map.Entry<String, String>> properties) {
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImmutableProperty> hidden = new ArrayList<ImmutableProperty>(properties.size());
        for (Map.Entry<String, String> entry : properties) {
            hidden.add(ImmutableProperty.makeImmutable(entry));
        }
        return Collections.unmodifiableList(hidden);
    }

    public static List<ImmutablePropertyPair> makeImmutableModificationList(Collection<? extends Map.Entry<? extends IProperty, ? extends IProperty>> mods) {
        if (mods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImmutablePropertyPair> hidden = new ArrayList<ImmutablePropertyPair>(mods.size());
        for (Map.Entry<? extends IProperty, ? extends IProperty> entry : mods) {
            if (entry instanceof ImmutablePropertyPair) {
                hidden.add((ImmutablePropertyPair)entry);
                continue;
            }
            hidden.add(new ImmutablePropertyPair(entry));
        }
        return Collections.unmodifiableList(hidden);
    }
}

