/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.property.BooleanPropertyDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.ICorpusConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.core.property.ModelConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.XMLUtils;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CorpusConfiguration
extends ModelConfiguration
implements ICorpusConfiguration {
    public CorpusConfiguration(IProject p) {
        this(CorpusConfiguration.createProjectConfigDescriptor(p));
    }

    public CorpusConfiguration(IDescriptor d) {
        super(d);
    }

    public CorpusConfiguration(ICorpusConfiguration c) {
        super(c);
    }

    public CorpusConfiguration clone() {
        return new CorpusConfiguration(this);
    }

    public boolean addSupport(IRep rep) {
        if (!super.addSupport(rep)) {
            return false;
        }
        this.putProperty(this.generateRequiredDescriptor(rep));
        return true;
    }

    public boolean removeSupport(IRep rep) {
        if (!super.removeSupport(rep)) {
            return false;
        }
        this.removeProperty(CorpusConfiguration.getBuilderKey(rep));
        this.removeProperty(CorpusConfiguration.getRequiredKey(rep));
        return true;
    }

    protected IPropertyDescriptor generateRequiredDescriptor(IRep rep) {
        return new BooleanPropertyDescriptor(CorpusConfiguration.getRequiredKey(rep), rep.getName(), rep.getDescription(), false);
    }

    public void setRequired(IRep rep, boolean value) {
        if (!this.supports(rep)) {
            return;
        }
        this.put(CorpusConfiguration.getRequiredKey(rep), Boolean.toString(value));
    }

    public boolean isRequired(IRep rep) {
        return Boolean.parseBoolean(this.get(CorpusConfiguration.getRequiredKey(rep)));
    }

    public String getBuilderID(IRep key) {
        return this.get(CorpusConfiguration.getBuilderKey(key));
    }

    public IConfiguration getBuilderConfiguration(IRep key) {
        return this.getConfigurations().get(CorpusConfiguration.getBuilderKey(key));
    }

    public String putBuilderID(IRep rep, String id) {
        String key = CorpusConfiguration.getBuilderKey(rep);
        String oldID = this.put(key, id);
        IConfiguration currConfig = this.getConfigurations().get(key);
        if (currConfig != null && !currConfig.getID().equals(id)) {
            this.getConfigurations().put(key, null);
        }
        return oldID;
    }

    public IConfiguration putBuilderConfiguration(IRep rep, IConfiguration config) {
        String key = CorpusConfiguration.getBuilderKey(rep);
        this.put(key, config.getID());
        return this.getConfigurations().put(key, config);
    }

    public static String getRequiredKey(IRep rep) {
        return String.valueOf(rep.getID()) + ".required";
    }

    public static String getBuilderKey(IRep rep) {
        return String.valueOf(rep.getID()) + ".builder";
    }

    public static ICorpusConfiguration fromXML(IProject project, Document xml) {
        IRep rep;
        Element parentNode;
        IDescriptor desc = CorpusConfiguration.createProjectConfigDescriptor(project);
        CorpusConfiguration result = new CorpusConfiguration(desc);
        NodeList nodeList = xml.getElementsByTagName("rep");
        IFactoryManager fm = StoryPlugin.getDefault().getFactoryManager();
        TreeMap<IRep, Element> repMap = new TreeMap<IRep, Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            parentNode = (Element)nodeList.item(i);
            String repID = XMLUtils.extractID(parentNode);
            rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
            if (rep != null) {
                repMap.put(rep, parentNode);
            }
            ++i;
        }
        for (Map.Entry entry : repMap.entrySet()) {
            String id;
            IFactoryDescriptor factoryDesc;
            NodeList children;
            Element childNode;
            IConfiguration config;
            IConfigDescriptor configDesc;
            rep = (IRep)entry.getKey();
            parentNode = (Element)entry.getValue();
            result.addSupport(rep);
            boolean required = Boolean.parseBoolean(parentNode.getAttribute("required"));
            if (required) {
                result.setRequired(rep, required);
            }
            if ((configDesc = rep.getConfigurationDescriptor()) != null) {
                config = XMLUtils.extractConfiguration(parentNode);
                config = configDesc.create(config);
                result.putRepConfiguration(rep, config);
            }
            Element element = childNode = (children = parentNode.getElementsByTagName("factory")).getLength() == 1 ? (Element)children.item(0) : null;
            if (childNode == null || (factoryDesc = (IFactoryDescriptor)fm.getDescriptor(id = XMLUtils.extractID(childNode))) == null) continue;
            result.putFactoryID(rep, id);
            configDesc = factoryDesc.getConfigurationDescriptor();
            if (configDesc == null) continue;
            config = XMLUtils.extractConfiguration(childNode);
            config = configDesc.create(config);
            result.putFactoryConfiguration(rep, config);
        }
        return result;
    }

    public static IDescriptor createProjectConfigDescriptor(IProject project) {
        return new Descriptor(project.getFullPath().toPortableString(), String.valueOf(project.getName()) + " Project Configuration", "");
    }
}

