/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.AbstractPosition;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IMutablePosition;
import org.eclipse.jface.text.Position;

public class StoryPosition
extends AbstractPosition
implements IMutablePosition {
    private static final long serialVersionUID = 6679595184758693409L;
    private int fOffset;
    private int fLength;
    private int fRight;

    public StoryPosition(Position p) {
        this(p.getOffset(), p.getLength());
    }

    public StoryPosition(IHasPosition p) {
        this(p.getOffset(), p.getLength());
    }

    public StoryPosition(int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        this.fOffset = offset;
        this.fLength = length;
        this.fRight = this.fOffset + this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getRightOffset() {
        return this.fRight;
    }

    public boolean setOffset(int offset) {
        assert (offset >= 0);
        if (this.fOffset == offset) {
            return false;
        }
        this.fOffset = offset;
        this.fRight = this.fOffset + this.fLength;
        return true;
    }

    public boolean setLength(int length) {
        assert (length >= 0);
        if (this.fLength == length) {
            return false;
        }
        this.fLength = length;
        this.fRight = this.fOffset + this.fLength;
        return true;
    }
}

