/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IRegionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.RegionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.util.Immutable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctRegionSet
extends RegionSet {
    public DistinctRegionSet() {
    }

    public DistinctRegionSet(Collection<? extends IHasPosition> c) {
        super(c);
    }

    protected DistinctRegionSet(RegionSet parent, IHasPosition fromPos, IHasPosition toPos, int fromOffset, int toOffset, boolean open) {
        super(parent, fromPos, toPos, fromOffset, toOffset, open);
    }

    @Override
    protected RegionSet createSubset(RegionSet parent, IHasPosition fromElement, IHasPosition toElement, int fromOffset, int toOffset, boolean closed) {
        return new DistinctRegionSet(parent, fromElement, toElement, fromOffset, toOffset, closed);
    }

    protected IHasPositionSet<IHasPosition> getOverlap(IHasPosition p) {
        return this.openSet(p);
    }

    public boolean add(int offset, int length) {
        return this.add(new SimplePosition(offset, length));
    }

    @Override
    public boolean add(IHasPosition p) {
        if (!this.isValid(p)) {
            this.throwException(p);
        }
        if (this.isEmpty()) {
            return p instanceof Immutable ? super.add(p) : super.add(new SimplePosition(p));
        }
        IHasPositionSet<IHasPosition> overlap = this.getOverlap(p);
        if (overlap.isEmpty()) {
            return p instanceof Immutable ? super.add(p) : super.add(new SimplePosition(p));
        }
        int left = Math.min(p.getOffset(), overlap.getOffset());
        int right = Math.max(p.getRightOffset(), overlap.getRightOffset());
        overlap.clear();
        return super.add(new SimplePosition(left, right - left));
    }

    @Override
    public boolean addAll(Collection<? extends IHasPosition> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (this.isSubview(c)) {
            return false;
        }
        boolean modified = false;
        for (IHasPosition iHasPosition : c) {
            if (!this.add(iHasPosition)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean subtract(int offset, int length) {
        return this.subtract(new SimplePosition(offset, length));
    }

    public boolean subtract(IHasPosition p) {
        IRegionSet overlap = this.openSet(p);
        if (overlap.size() == 0) {
            return false;
        }
        RegionSet oldRegions = new RegionSet(overlap);
        overlap.clear();
        for (IHasPosition region : oldRegions) {
            IHasPosition section = PositionUtils.intersection(region, p);
            if (section == null) continue;
            if (region.getOffset() < section.getOffset()) {
                this.add(new SimplePosition(region.getOffset(), section.getOffset() - region.getOffset()));
            }
            if (section.getRightOffset() >= region.getRightOffset()) continue;
            this.add(new SimplePosition(section.getRightOffset(), region.getRightOffset() - section.getRightOffset()));
        }
        return true;
    }

    public boolean subtractAll(Collection<? extends IHasPosition> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (IHasPosition iHasPosition : c) {
            if (!this.subtract(iHasPosition)) continue;
            modified = true;
        }
        return modified;
    }
}

