/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.NotifyingSet;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingSortedSet<E>
extends NotifyingSet<E>
implements SortedSet<E> {
    protected final SortedSet<E> backingSet;

    public NotifyingSortedSet(INotifyCollectionCallback<E> callback) {
        this((Comparator<E>)null, callback);
    }

    public NotifyingSortedSet(Comparator<E> comparator, INotifyCollectionCallback<E> callback) {
        this(new TreeSet<E>(comparator), callback);
    }

    protected NotifyingSortedSet(SortedSet<E> backingSet, INotifyCollectionCallback<E> callback) {
        super(backingSet, callback);
        this.backingSet = backingSet;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingSet.comparator();
    }

    @Override
    public E first() {
        return this.backingSet.first();
    }

    @Override
    public E last() {
        return this.backingSet.last();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.makeSubSet(null, toElement);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.makeSubSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.makeSubSet(fromElement, null);
    }

    protected NotifyingSortedSet<E> makeSubSet(E fromElement, E toElement) {
        if (fromElement == null) {
            return new NotifyingSortedSet<E>(this.backingSet.headSet(fromElement), this.callback);
        }
        if (toElement == null) {
            return new NotifyingSortedSet<E>(this.backingSet.tailSet(fromElement), this.callback);
        }
        return new NotifyingSortedSet<E>(this.backingSet.subSet(fromElement, toElement), this.callback);
    }
}

