/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.AddMetadataChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryChangeEventIntegrator {
    Object source = null;
    IMutableStoryModel provider = null;
    Map<IRep, List<Change>> changes;
    List<IModelChange> doList;
    List<IModelChange> undoList;

    public StoryChangeEventIntegrator() {
    }

    public StoryChangeEventIntegrator(StoryChangeEvent event) {
        this.addEvent(event);
    }

    public StoryChangeEventIntegrator(Object source, IMutableStoryModel provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
    }

    public Object getSource() {
        return this.source;
    }

    public IMutableStoryModel getModel() {
        return this.provider;
    }

    protected void init(StoryChangeEvent event) {
        if (event == null) {
            return;
        }
        this.source = event.source;
        this.provider = event.provider;
    }

    public boolean isNull() {
        if (this.provider == null) {
            return true;
        }
        boolean s = this.changes == null ? true : this.changes.isEmpty();
        boolean d = this.doList == null ? true : this.doList.isEmpty();
        boolean u = this.undoList == null ? true : this.undoList.isEmpty();
        return s & d & u;
    }

    public IRepSet getAffectedRepresentations() {
        return new RepSet(this.changes.keySet());
    }

    public boolean canIntegrate(StoryChangeEvent event) {
        if (event == null) {
            return true;
        }
        if (this.source == null & this.provider == null) {
            return true;
        }
        return this.source == event.source & this.provider == event.provider;
    }

    public void addEvent(StoryChangeEvent event) {
        if (event == null) {
            return;
        }
        if (this.source == null & this.provider == null) {
            this.init(event);
        }
        if (!this.canIntegrate(event)) {
            StringBuilder sb = new StringBuilder();
            sb.append("There was a problem integrating an event:\n");
            sb.append(event.toString());
            sb.append('\n');
            StoryChangeEvent e = this.asEvent();
            sb.append(e == null ? "null" : e.toString());
            StoryPlugin.getDefault().getLog().log((IStatus)new Status(4, "edu.mit.story.core", sb.toString()));
            return;
        }
        for (Map.Entry<IRep, Change> entry : event.changes.entrySet()) {
            this.addChange(entry.getKey(), entry.getValue());
        }
        this.addDoChange(event.doChange);
        this.addUndoChange(event.undoChange);
    }

    public void addChange(IRep rep, Change summary) {
        if (rep == null | summary == null) {
            return;
        }
        this.getChanges(rep).add(summary);
    }

    public void addDoChange(IModelChange change) {
        if (change == null) {
            return;
        }
        this.getDoList().add(change);
    }

    public void addUndoChange(IModelChange change) {
        if (change == null) {
            return;
        }
        this.getUndoList().add(change);
    }

    public void metadataAdded(Map<IMetaDesc<?>, IHasPosition> descs) {
        if (descs == null || descs.isEmpty()) {
            return;
        }
        for (Map.Entry<IMetaDesc<?>, IHasPosition> e : descs.entrySet()) {
            this.addChange(e.getKey().getRep(), new Change(Flag.METADATA_ADDED, new IHasPosition[]{e.getValue()}));
        }
        this.addDoChange(new AddMetadataChange(descs.keySet()));
        this.addUndoChange(new RemoveMetadataChange((Iterable<? extends IMetaDesc<?>>)descs.keySet()));
    }

    public void metadataRemoved(Map<IMetaDesc<?>, IHasPosition> descs) {
        if (descs == null || descs.isEmpty()) {
            return;
        }
        for (Map.Entry<IMetaDesc<?>, IHasPosition> e : descs.entrySet()) {
            this.addChange(e.getKey().getRep(), new Change(Flag.METADATA_ADDED, new IHasPosition[]{e.getValue()}));
        }
        this.addDoChange(new RemoveMetadataChange((Iterable<? extends IMetaDesc<?>>)descs.keySet()));
        this.addUndoChange(new AddMetadataChange(descs.keySet()));
    }

    public void descriptionAdded(IDesc desc) {
        if (desc == null) {
            return;
        }
        this.addChange(desc.getRep(), new Change(Flag.DESC_ADDED, (IHasPosition[])new IDesc[]{desc}));
        this.addDoChange(new AddDescriptionsChange(desc));
        this.addUndoChange(new RemoveDescriptionsChange(desc));
    }

    public void descriptionsAdded(Collection<? extends IDesc> descs) {
        if (descs == null || descs.isEmpty()) {
            return;
        }
        for (IDesc iDesc : descs) {
            this.addChange(iDesc.getRep(), new Change(Flag.DESC_ADDED, (IHasPosition[])new IDesc[]{iDesc}));
        }
        this.addDoChange(new AddDescriptionsChange(descs));
        this.addUndoChange(new RemoveDescriptionsChange(descs));
    }

    public void descriptionRemoved(IDesc desc) {
        if (desc == null) {
            return;
        }
        this.addChange(desc.getRep(), new Change(Flag.DESC_REMOVED, (IHasPosition[])new IDesc[]{desc}));
        this.addDoChange(new RemoveDescriptionsChange(desc));
        this.addUndoChange(new AddDescriptionsChange(desc));
    }

    public void descriptionsRemoved(Collection<? extends IDesc> descs) {
        if (descs == null) {
            return;
        }
        if (descs.isEmpty()) {
            return;
        }
        for (IDesc iDesc : descs) {
            this.addChange(iDesc.getRep(), new Change(Flag.DESC_REMOVED, (IHasPosition[])new IDesc[]{iDesc}));
        }
        this.addDoChange(new RemoveDescriptionsChange(descs));
        this.addUndoChange(new AddDescriptionsChange(descs));
    }

    public StoryChangeEvent asEvent() {
        List undos;
        if (this.isNull()) {
            return null;
        }
        if (this.undoList == null || this.undoList.isEmpty()) {
            undos = Collections.emptyList();
        } else {
            undos = new ArrayList<IModelChange>(this.undoList);
            Collections.reverse(undos);
        }
        return new StoryChangeEvent(this.source, this.provider, ChangeUtils.compressChangeMap(this.changes), new CompositeModelChange(this.doList), new CompositeModelChange(undos));
    }

    public boolean changed(IRep rep, IFlag<?> flag) {
        if (this.changes == null) {
            return false;
        }
        List<Change> changeList = this.changes.get(rep);
        if (changeList == null) {
            return false;
        }
        for (Change change : changeList) {
            if (!change.changed(flag)) continue;
            return true;
        }
        return false;
    }

    protected List<Change> getChanges(IRep rep) {
        List<Change> changeList = this.getChanges().get(rep);
        if (changeList == null) {
            changeList = new ArrayList<Change>();
            this.changes.put(rep, changeList);
        }
        return changeList;
    }

    protected Map<IRep, List<Change>> getChanges() {
        if (this.changes == null) {
            this.changes = new HashMap<IRep, List<Change>>();
        }
        return this.changes;
    }

    protected List<IModelChange> getDoList() {
        if (this.doList == null) {
            this.doList = new ArrayList<IModelChange>();
        }
        return this.doList;
    }

    protected List<IModelChange> getUndoList() {
        if (this.undoList == null) {
            this.undoList = new ArrayList<IModelChange>();
        }
        return this.undoList;
    }

    public static boolean canIntegrate(StoryChangeEvent one, StoryChangeEvent two) {
        if (one == null | two == null) {
            return true;
        }
        return one.provider == two.provider & one.source == two.source;
    }
}

