/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.Immutable;
import edu.mit.story.core.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryChangeEvent
implements Immutable {
    public final Object source;
    public final IMutableStoryModel provider;
    public final SortedMap<IRep, Change> changes;
    public final Change overall;
    public final IModelChange doChange;
    public final IModelChange undoChange;

    public StoryChangeEvent(StoryChangeEvent event) {
        this(event.source, event.provider, event.changes, event.doChange, event.undoChange);
    }

    public StoryChangeEvent(Object source, IMutableStoryModel provider, IRep rep, Change change, IModelChange doChange, IModelChange undoChange) {
        if (provider == null || rep == null || change == null || doChange == null || undoChange == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
        this.changes = ChangeUtils.createChangeMap(rep, change);
        this.overall = ChangeUtils.createOverallChange(this.changes);
        this.doChange = doChange;
        this.undoChange = undoChange;
    }

    public StoryChangeEvent(Object source, IMutableStoryModel provider, IRepSet reps, Change change, IModelChange doChange, IModelChange undoChange) {
        if (provider == null || reps == null || change == null || doChange == null || undoChange == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
        this.changes = ChangeUtils.createChangeMap(reps, change);
        this.overall = ChangeUtils.createOverallChange(this.changes);
        this.doChange = doChange;
        this.undoChange = undoChange;
    }

    public StoryChangeEvent(Object source, IMutableStoryModel provider, IRep rep, Change change, List<IModelChange> doList, List<IModelChange> undoList) {
        if (provider == null || rep == null || change == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
        this.changes = ChangeUtils.createChangeMap(rep, change);
        this.overall = ChangeUtils.createOverallChange(this.changes);
        this.doChange = ChangeUtils.createChange(doList);
        this.undoChange = ChangeUtils.createChange(undoList);
    }

    public StoryChangeEvent(Object source, IMutableStoryModel provider, Map<IRep, Change> changeMap, IModelChange doChange, IModelChange undoChange) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
        this.changes = ChangeUtils.createChangeMap(changeMap);
        this.overall = ChangeUtils.createOverallChange(changeMap);
        this.doChange = doChange;
        this.undoChange = undoChange;
    }

    public StoryChangeEvent(Object source, IMutableStoryModel provider, Map<IRep, Change> changeMap, List<IModelChange> doList, List<IModelChange> undoList) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.provider = provider;
        this.changes = ChangeUtils.createChangeMap(changeMap);
        this.overall = ChangeUtils.createOverallChange(changeMap);
        this.doChange = ChangeUtils.createChange(doList);
        this.undoChange = ChangeUtils.createChange(undoList);
    }

    public Object getSource() {
        return this.source;
    }

    public IStoryModel getModel() {
        return this.provider;
    }

    public StoryChangeEventIntegrator createIntegrator() {
        return new StoryChangeEventIntegrator(this.source, this.provider);
    }

    public IRepSet getReps() {
        return new RepSet(this.changes.keySet());
    }

    public boolean affects(IRep rep) {
        return this.changes.keySet().contains(rep);
    }

    public boolean affects(Collection<IRep> reps) {
        for (IRep rep : reps) {
            if (!this.affects(rep)) continue;
            return true;
        }
        return false;
    }

    public Change getOverall() {
        return this.overall;
    }

    public Change getChange(IRep rep) {
        return (Change)this.changes.get(rep);
    }

    public String toString() {
        String addr = Integer.toHexString(this.hashCode());
        String className = StringUtils.getClassName(this.getClass());
        String sourceName = this.source == null ? null : StringUtils.getClassName(this.source.getClass());
        Object[] reps = this.changes.keySet().toArray(new IRep[this.changes.keySet().size()]);
        return String.valueOf(className) + '@' + addr + "[source=" + sourceName + ", reps=" + StringUtils.toString(reps) + ", overall=" + (this.overall != null ? this.overall.toString() : this.overall) + "]";
    }
}

