/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.position.IHasPosition;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flag<T extends IHasPosition>
implements IFlag<T> {
    public static final IFlag<IStoryModel> LENGTH_INCREASED = new Flag<IStoryModel>("length_increased", "Index length increased");
    public static final IFlag<IStoryModel> LENGTH_DECREASED = new Flag<IStoryModel>("length_decreased", "Index length decreased");
    public static final IFlag<IStoryModel> REP_ADDED = new Flag<IStoryModel>("rep_added", "A representation was added.");
    public static final IFlag<IStoryModel> REP_REMOVED = new Flag<IStoryModel>("rep_removed", "A representation was added.");
    public static final IFlag<IStoryModel> CONFIG_CHANGED = new Flag<IStoryModel>("config_changed", "A representation configuration was changed.");
    public static final IFlag<IHasPosition> METADATA_ADDED = new Flag<IHasPosition>("metadata_added", "Metadata was added to the model.");
    public static final IFlag<IHasPosition> METADATA_REMOVED = new Flag<IHasPosition>("metadata_removed", "Metadata was removed from the model.");
    public static final IFlag<IDesc> DESC_ADDED = new Flag<IDesc>("desc_added", "A description was removed.");
    public static final IFlag<IDesc> DESC_REMOVED = new Flag<IDesc>("desc_removed", "A description was added.");
    public static final Flags<IStoryModel> LENGTH = new Flags("length", "length increased or decreased", LENGTH_DECREASED, LENGTH_INCREASED);
    public static final Flags<IStoryModel> REPS = new Flags("reps", "rep added or removed, or config changed", REP_ADDED, REP_REMOVED, CONFIG_CHANGED);
    public static final Flags<IHasPosition> METADATA = new Flags("metadata", "metadata added or removed", METADATA_ADDED, METADATA_REMOVED);
    public static final Flags<IDesc> DESCS = new Flags("descs", "desc added or removed", DESC_ADDED, DESC_REMOVED);
    private final String fName;
    private final String fDesc;

    private Flag(String name, String description) {
        this.fName = name;
        this.fDesc = description;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getDescription() {
        return this.fDesc;
    }

    public String toString() {
        return "Flag:" + this.getName();
    }

    public boolean isFlagSet() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Flags<T extends IHasPosition>
    extends AbstractSet<IFlag<T>>
    implements IFlag.IFlagSet<T> {
        private final String name;
        private final String desc;
        private final Set<IFlag<T>> backingSet;

        public Flags(String name, String desc, IFlag<T> ... flags) {
            this(name, desc, Arrays.asList(flags));
        }

        public Flags(String name, String desc, Collection<? extends IFlag<T>> flags) {
            if (name == null || desc == null) {
                throw new NullPointerException();
            }
            if (flags.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.desc = desc;
            HashSet<IFlag<T>> hidden = new HashSet<IFlag<T>>(flags.size());
            for (IFlag<T> flag : flags) {
                if (flag instanceof IFlag.IFlagSet) {
                    throw new IllegalArgumentException();
                }
                hidden.add(flag);
            }
            this.backingSet = Collections.unmodifiableSet(hidden);
        }

        @Override
        public Iterator<IFlag<T>> iterator() {
            return this.backingSet.iterator();
        }

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

