/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.util.ArrayUtils;
import edu.mit.story.core.util.IUtilityClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeUtils
implements IUtilityClass {
    private ChangeUtils() {
    }

    public static void edit(Object source, IMutableStoryModel model, IRep rep, IHasPosition p, IData data, ITiming editTime, IDesc oldDesc) {
        IModelChange change = ChangeUtils.createModelEdit(source, model, rep, p, data, editTime, oldDesc);
        model.applyChange(source, change, false);
    }

    public static IModelChange createModelEdit(Object source, IMutableStoryModel model, IRep rep, IHasPosition p, IData data, ITiming editTime, IDesc oldDesc) {
        long id = oldDesc == null ? model.getNextID() : oldDesc.getID();
        Desc newDesc = new Desc(id, rep, p, data, oldDesc == null ? null : oldDesc.getMetaData());
        newDesc.getMetaData().addDesc(new MetaDesc<Origin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
        if (editTime != null) {
            MetaDesc<ITiming> metaDesc = new MetaDesc<ITiming>(TimingMetaRep.getInstance(), newDesc, editTime);
            newDesc.getMetaData().addDesc(metaDesc);
        }
        AbstractModelChange change = new AddDescriptionsChange(newDesc);
        if (oldDesc != null) {
            change = new CompositeModelChange(new RemoveDescriptionsChange(oldDesc), change);
        }
        return change;
    }

    public static SortedMap<IRep, Change> createChangeMap(IRep rep, Change change) {
        if (rep == null | change == null) {
            return ArrayUtils.emptySortedMap();
        }
        TreeMap<IRep, Change> hidden = new TreeMap<IRep, Change>();
        hidden.put(rep, change);
        return Collections.unmodifiableSortedMap(hidden);
    }

    public static SortedMap<IRep, Change> createChangeMap(IRepSet reps, Change change) {
        if (reps == null | change == null) {
            return ArrayUtils.emptySortedMap();
        }
        if (reps.isEmpty()) {
            return ArrayUtils.emptySortedMap();
        }
        TreeMap<IRep, Change> hidden = new TreeMap<IRep, Change>();
        for (IRep rep : reps) {
            hidden.put(rep, change);
        }
        return Collections.unmodifiableSortedMap(hidden);
    }

    public static SortedMap<IRep, Change> createChangeMap(Map<IRep, Change> input) {
        if (input == null) {
            return ArrayUtils.emptySortedMap();
        }
        if (input.isEmpty()) {
            return ArrayUtils.emptySortedMap();
        }
        TreeMap<IRep, Change> hidden = new TreeMap<IRep, Change>();
        for (Map.Entry<IRep, Change> entry : input.entrySet()) {
            if (entry.getKey() == null | entry.getValue() == null) continue;
            hidden.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableSortedMap(hidden);
    }

    public static IModelChange createChange(List<IModelChange> input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return null;
        }
        return new CompositeModelChange(null, input);
    }

    protected static String toBinaryString(int flags) {
        String result = Integer.toBinaryString(flags);
        if (result.length() > 4) {
            return result.substring(result.length() - 4);
        }
        int i = result.length();
        while (i < 4) {
            result = "0" + result;
            ++i;
        }
        return result;
    }

    public static Change createOverallChange(Map<IRep, Change> changes) {
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        if (changes.size() == 1) {
            return changes.values().iterator().next();
        }
        return new Change(changes.values());
    }

    public static Change combine(Change one, Change two) {
        if (one == null & two == null) {
            return null;
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return new Change(one, two);
    }

    public static Map<IRep, Change> compressChangeMap(Map<IRep, List<Change>> input) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IRep, Change> result = new HashMap<IRep, Change>();
        for (Map.Entry<IRep, List<Change>> entry : input.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            if (entry.getValue().size() == 1) {
                result.put(entry.getKey(), entry.getValue().get(0));
                continue;
            }
            result.put(entry.getKey(), new Change((Collection<? extends Change>)entry.getValue()));
        }
        return result;
    }

    public static StoryChangeEvent combine(StoryChangeEvent one, StoryChangeEvent two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        StoryChangeEventIntegrator integrator = one.createIntegrator();
        if (!integrator.canIntegrate(two)) {
            return null;
        }
        integrator.addEvent(one);
        integrator.addEvent(two);
        return integrator.asEvent();
    }
}

