/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.util.XMLUtils;
import java.util.Iterator;
import org.w3c.dom.Document;

public class XMLBackedStoryModel
extends StoryModel {
    private static final long serialVersionUID = -8823741818271612435L;

    public XMLBackedStoryModel(IRep primary) {
        super(primary);
    }

    public void setXML(String xmlText) {
        IRep rep;
        StoryModelImporter importer = new StoryModelImporter();
        IMutableStoryModel newModel = importer.importFromXML(xmlText, null);
        IStoryData newData = newModel.getData();
        long maxID = 0L;
        for (IDesc d : newData) {
            maxID = Math.max(maxID, d.getID());
        }
        this.setNextID(++maxID);
        IRepSet removeThese = this.descs.getSupported();
        IRepSet addThese = newModel.getSupported();
        removeThese.removeAll(addThese);
        addThese.removeAll(this.descs.getSupported());
        this.descs.clear();
        this.descs.removeAllSupport(removeThese);
        this.descs.addAllSupport(addThese);
        Iterator i = newModel.repIterator();
        while (i.hasNext()) {
            rep = (IRep)i.next();
            IConfiguration config = newModel.getData().getConfiguration(rep);
            if (config == null) continue;
            this.descs.setConfiguration(config);
        }
        this.descs.addAll(newData);
        this.factories.clear();
        Iterator i2 = this.descs.repIterator();
        while (i2.hasNext()) {
            rep = (IRep)i2.next();
            IDescFactory factory = newModel.getFactory(rep);
            if (factory == null) continue;
            this.factories.put(rep, factory);
        }
        this.descs.getMetadata().addAllDescs(newData.getMetadata());
    }

    public String getXML() {
        Document doc = StoryModelExporter.getInstance().exportToXML(this);
        return XMLUtils.toString(doc);
    }
}

