/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.rep.IMutableRepSupporter;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.UnsupportedRepException;
import edu.mit.story.core.util.ImmutableIterator;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedMultiSet
extends DescMultiSet
implements IMutableRepSupporter {
    private static final long serialVersionUID = -2160016818490708768L;
    protected final IRepSet fSupported;

    public RestrictedMultiSet() {
        this.fSupported = this.createSupportSet(null);
        for (IRep rep : this.fSupported) {
            this.createDescriptionSet(rep, null, null);
        }
    }

    public RestrictedMultiSet(IRepSet supportSet) {
        if (supportSet == null) {
            throw new NullPointerException();
        }
        this.fSupported = this.createSupportSet(supportSet);
    }

    public RestrictedMultiSet(Collection<? extends IDesc> c) {
        super(c);
        this.fSupported = this.createSupportSet(RepUtils.extractRepresentations(c));
    }

    protected void check(IRep rep) {
        if (this.supports(rep)) {
            return;
        }
        throw new UnsupportedRepException(rep);
    }

    @Override
    public boolean add(IDesc d) {
        if (d != null) {
            this.check(d.getRep());
        }
        return super.add(d);
    }

    @Override
    protected boolean addUniformRepresentationSet(IRep rep, Collection<IDesc> descs) {
        this.check(rep);
        return super.addUniformRepresentationSet(rep, descs);
    }

    @Override
    public int size(IRep target) {
        this.check(target);
        return super.size(target);
    }

    @Override
    public IDesc getDescription(long id, IRep rep) {
        this.check(rep);
        return super.getDescription(id, rep);
    }

    @Override
    public IDescSet getDescriptions(IRep target) {
        this.check(target);
        return super.getDescriptions(target);
    }

    @Override
    public int repSize() {
        return this.fSupported.size();
    }

    @Override
    public boolean supports(IRep rep) {
        return this.fSupported.contains(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.fSupported.containsAll(reps);
    }

    @Override
    public IRepSet getSupported() {
        return new RepSet(this.fSupported);
    }

    @Override
    public Iterator<IRep> repIterator() {
        return new ImmutableIterator<IRep>(this.fSupported.iterator());
    }

    @Override
    public boolean addSupport(IRep rep) {
        if (!this.fSupported.add(rep)) {
            return false;
        }
        this.createDescriptionSet(rep, null, null);
        return true;
    }

    @Override
    public boolean addAllSupport(Collection<? extends IRep> reps) {
        boolean changed = false;
        RepSet repSet = new RepSet(reps);
        for (IRep rep : repSet) {
            if (!this.addSupport(rep)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeSupport(IRep rep) {
        IDescSet descSet = this.getDescriptions(rep);
        if (!this.fSupported.remove(rep)) {
            return false;
        }
        descSet.clear();
        this.repMap.remove(rep);
        return true;
    }

    @Override
    public boolean removeAllSupport(Collection<? extends IRep> reps) {
        boolean changed = false;
        for (IRep iRep : reps) {
            if (!this.removeSupport(iRep)) continue;
            changed = true;
        }
        return changed;
    }
}

