/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta.timing;

import edu.mit.story.core.meta.timing.ITiming;
import java.util.Date;

public class Timing
implements ITiming {
    private final Date start;
    private final Date stop;
    private final String source;

    public Timing(String source, boolean isCreationTime) {
        this(isCreationTime ? new Date() : null, isCreationTime ? null : new Date(), source);
    }

    public Timing(Date start, String source) {
        this(start, new Date(), source);
    }

    public Timing(Date start, Date end, String source) {
        if (start == end) {
            throw new IllegalArgumentException();
        }
        if (start == null && end == null) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.stop = end;
        this.source = source;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public String getSource() {
        return this.source;
    }

    public int compareTo(ITiming t) {
        Date myFirst = this.start == null ? this.stop : this.start;
        Date mySecond = this.stop == null ? this.start : this.stop;
        Date theirFirst = t.getStart() == null ? t.getStop() : t.getStart();
        Date theirSecond = t.getStop() == null ? t.getStart() : t.getStop();
        int cmp = myFirst.compareTo(theirFirst);
        if (cmp != 0) {
            return cmp;
        }
        cmp = mySecond.compareTo(theirSecond);
        if (cmp != 0) {
            return cmp;
        }
        return this.source.compareTo(t.getSource());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timing other = (Timing)obj;
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.stop == null ? other.stop != null : !this.stop.equals(other.stop));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[start=" + this.start.getTime());
        sb.append(", stop=" + this.start.getTime() + ']');
        return sb.toString();
    }
}

