/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta;

import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import java.util.Collection;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataSet<D extends IMetaData>
extends TreeSet<IMetaDesc<D>>
implements IMetaDataSet<D> {
    private static final long serialVersionUID = 5150710209829607052L;
    private final IMetaRep<D> meta;

    public MetaDataSet(IMetaDesc<D> desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.meta = desc.getMetaRep();
        this.add(desc);
    }

    public MetaDataSet(IMetaRep<D> meta) {
        if (meta == null) {
            throw new NullPointerException();
        }
        this.meta = meta;
    }

    public MetaDataSet(Collection<? extends IMetaDesc<D>> c) {
        this.meta = c.iterator().next().getMetaRep();
        this.addAll((Collection<? extends IMetaDesc<D>>)c);
    }

    public MetaDataSet(IMetaDataSet<D> s) {
        this.meta = s.getMetaRep();
        this.addAll((Collection<? extends IMetaDesc<D>>)s);
    }

    @Override
    public IMetaRep<D> getMetaRep() {
        return this.meta;
    }

    @Override
    public boolean add(IMetaDesc<D> o) {
        if (!this.meta.isType(o)) {
            throw new IllegalArgumentException();
        }
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends IMetaDesc<D>> c) {
        if (c instanceof IMetaDataSet) {
            IMetaDataSet s = (IMetaDataSet)c;
            if (!this.meta.isType(s)) {
                throw new IllegalArgumentException();
            }
            return super.addAll(c);
        }
        boolean modified = false;
        for (IMetaDesc<D> d : c) {
            modified |= this.add(d);
        }
        return modified;
    }
}

