/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionValueMapper
implements IValueMapper<IDesc> {
    private static final String semicolon = ";";
    IDescMultiSet source;

    public DescriptionValueMapper() {
        this(null);
    }

    public DescriptionValueMapper(IDescMultiSet source) {
        this.setSource(source);
    }

    public void setSource(IDescMultiSet source) {
        this.source = source;
    }

    public IDescMultiSet getSource() {
        return this.source;
    }

    @Override
    public String serialize(Collection<? extends IDesc> descriptions) {
        if (descriptions == null || descriptions.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<? extends IDesc> i = descriptions.iterator();
        while (i.hasNext()) {
            sb.append(i.next().getID());
            if (!i.hasNext()) continue;
            sb.append(semicolon);
        }
        return sb.toString();
    }

    @Override
    public List<IDesc> reconstitute(String value) {
        String[] idStrs;
        if (this.source == null) {
            return null;
        }
        ArrayList<IDesc> result = new ArrayList<IDesc>();
        if (StringUtils.isEmpty(value)) {
            return result;
        }
        String[] stringArray = idStrs = value.split(semicolon);
        int n = idStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String idStr = stringArray[n2];
            try {
                long id = Long.parseLong(idStr);
                IDesc desc = this.source.getDescription(id);
                if (desc != null) {
                    result.add(desc);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return result;
    }
}

