/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.ImmutableHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentSet
extends ImmutableHasPositionSet<ISegment>
implements ISegmentSet {
    private final String text;
    private final IDescSet descs;

    public SegmentSet(Collection<? extends ISegment> segs) {
        super(segs);
        IRep rep = null;
        DescSet hidden = null;
        for (ISegment seg : this) {
            if (rep == null) {
                rep = seg.getRep();
                hidden = new DescSet(rep);
            }
            for (IDesc d : seg.getDescs()) {
                if (hidden.add(d)) continue;
                throw new IllegalArgumentException();
            }
        }
        this.descs = new ImmutableDescSet(hidden);
        StringBuffer sb = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            sb.append(((ISegment)i.next()).getDisplayText());
            if (!i.hasNext()) continue;
            sb.append("...");
        }
        this.text = sb.toString();
    }

    @Override
    public IRep getRep() {
        return this.descs.getRep();
    }

    @Override
    public IDescSet getDescs() {
        return this.descs;
    }

    @Override
    public IHasPositionSet<ISegment> getSegments() {
        return this;
    }

    @Override
    public String getDisplayText() {
        return this.text;
    }

    @Override
    public IHasPosition calculatePosition() {
        return new SimplePosition(this.descs);
    }

    @Override
    public IHasPosition getDisplayPosition() {
        return new SimplePosition(this.descs);
    }

    @Override
    public ISegmentSet recalculate(IDesc container, IStoryModel model) {
        LinkedList<ISegment> result = new LinkedList<ISegment>();
        boolean changed = false;
        for (ISegment oldSeg : this) {
            ISegment newSeg = (ISegment)oldSeg.recalculate(container, model);
            if (newSeg == null) {
                changed = true;
                continue;
            }
            if (newSeg != oldSeg) {
                changed = true;
                result.add(newSeg);
                continue;
            }
            result.add(oldSeg);
        }
        if (!changed) {
            return this;
        }
        if (result.isEmpty()) {
            return null;
        }
        return new SegmentSet((Collection<? extends ISegment>)result);
    }

    @Override
    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ISegmentSet.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ISegmentSet tgtSegs = (ISegmentSet)tgtData;
        return Data.equals(this, tgtSegs, model);
    }
}

