/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.core.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescUtils
implements IUtilityClass {
    public static boolean equalByIdentity(Collection<? extends IDesc> first, Collection<? extends IDesc> second) {
        if (first.size() != second.size()) {
            return false;
        }
        Iterator<? extends IDesc> itrOne = first.iterator();
        Iterator<? extends IDesc> itrTwo = second.iterator();
        while (itrOne.hasNext() && itrTwo.hasNext()) {
            if (itrOne.next() == itrTwo.next()) continue;
            return false;
        }
        return true;
    }

    public static String toClipboardDataString(Collection<IDescSet> dataSets) {
        if (dataSets == null || dataSets.isEmpty()) {
            return "";
        }
        TreeSet<IDescSet> descSets = new TreeSet<IDescSet>(dataSets);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (IDescSet descSet : descSets) {
            Iterator j = descSet.iterator();
            while (j.hasNext()) {
                String append = ((IDesc)j.next()).getDataString();
                if (append.equals("")) continue;
                if (!first) {
                    sb.append(StringUtils.getLineDelimiter());
                }
                sb.append(append);
                if (!first) continue;
                first = false;
            }
        }
        return sb.toString();
    }

    public static String toString(IDesc d) {
        String dataStr = d.getDataString();
        if (dataStr == null || dataStr.trim().length() == 0) {
            dataStr = d.getData().toString();
        }
        return "[" + d.getRep().getID() + "@" + DescUtils.toShortString(d) + ": " + dataStr + "]";
    }

    public static String toShortString(IDesc d) {
        return "[off=" + d.getOffset() + ",len=" + d.getLength() + "](" + d.getID() + ")";
    }

    public static boolean equalByOrder(IDesc one, IDesc two) {
        return DescUtils.compareAsDescriptions(one, two) == 0;
    }

    public static boolean definesNullSet(IDesc fromDesc, IDesc toDesc, int fromOffset, int toOffset) {
        if (fromDesc != null & toDesc != null) {
            if (toDesc.getRightOffset() < fromOffset | toOffset < fromDesc.getOffset()) {
                return true;
            }
            if (DescUtils.equalByOrder(fromDesc, toDesc)) {
                return true;
            }
        } else {
            if (fromDesc != null && toOffset < fromDesc.getOffset()) {
                return true;
            }
            if (toDesc != null && toDesc.getRightOffset() < fromOffset) {
                return true;
            }
        }
        return toOffset < fromOffset;
    }

    public static int compareAsDescriptions(IDesc one, IDesc two) {
        int result = RepUtils.compare(one.getRep(), two.getRep());
        if (result != 0) {
            return result;
        }
        result = one.getOffset() - two.getOffset();
        if (result != 0) {
            return result;
        }
        result = one.getLength() - two.getLength();
        if (result != 0) {
            return result;
        }
        return Double.compare(one.getID(), two.getID());
    }

    public static IDesc max(IDesc one, IDesc two) {
        int result = DescUtils.compareAsDescriptions(one, two);
        return result >= 0 ? one : two;
    }

    public static IDesc min(IDesc one, IDesc two) {
        int result = DescUtils.compareAsDescriptions(one, two);
        if (result < 0) {
            return one;
        }
        if (result > 0) {
            return two;
        }
        return one;
    }

    public static String toString(IDescSet ds) {
        return DescUtils.toString("", ds);
    }

    public static String toString(String linePrefix, IDescSet ds) {
        StringBuffer sb = new StringBuffer();
        if (ds == null) {
            sb.append(linePrefix);
            sb.append("null");
            return sb.toString();
        }
        int lastOffset = -1;
        for (IDesc desc : ds) {
            if (lastOffset != desc.getOffset()) {
                if (lastOffset != -1) {
                    sb.append('\n');
                }
                lastOffset = desc.getOffset();
                sb.append(linePrefix);
                sb.append(desc.getOffset());
                sb.append(": ");
            } else {
                sb.append(' ');
            }
            sb.append(PositionUtils.toString(desc));
        }
        if (sb.length() == 0) {
            sb.append(linePrefix);
            sb.append("(empty)");
        }
        return sb.toString();
    }

    public static <T extends IHasPosition> Map<T, IDesc> getMatchMap(Collection<? extends T> ps, IDescSet ds) {
        LinkedHashMap<IHasPosition, IDesc> result = new LinkedHashMap<IHasPosition, IDesc>();
        if (ds == null) {
            return result;
        }
        for (IHasPosition p : ps) {
            IDesc d = DescUtils.getSingleMatch(p, ds);
            if (d != null) {
                // empty if block
            }
            result.put(p, d);
        }
        return result;
    }

    public static IDesc getSingleMatch(IHasPosition p, IDescSet ds) {
        if (ds == null) {
            return null;
        }
        if ((ds = ds.matchSet(p)).size() != 1) {
            return null;
        }
        return (IDesc)ds.first();
    }

    public static IDescSet getDescriptions(IHasPosition p, IDescSet ds) {
        if (ds.isEmpty()) {
            return ds;
        }
        IDescSet subset = ds.openSet(p);
        return subset.isEmpty() ? ds.closedSet(p) : subset;
    }
}

