/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import com.google.common.base.Objects;
import edu.mit.story.core.datamodel.IResourcePairModel;
import edu.mit.story.core.datamodel.TagModel;
import edu.mit.story.core.validation.Message;
import java.io.File;
import org.eclipse.jface.dialogs.IMessageProvider;

public class ResourcePairModel
extends TagModel
implements IResourcePairModel {
    public static final Message sourceNotSelected = new Message("Select a source file or folder", 3);
    public static final Message sourceDoesNotExist = new Message("Source does not exist", 3);
    public static final Message targetNotSelected = new Message("Select a target file or folder", 3);
    public static final Message targetDoesNotExist = new Message("Target does not exist", 3);
    private File sourceFile;
    private File targetFile;

    public boolean setSource(File file) {
        if (Objects.equal((Object)file, (Object)this.sourceFile)) {
            return false;
        }
        this.sourceFile = file;
        this.fireChanged();
        return true;
    }

    public boolean setTarget(File file) {
        if (Objects.equal((Object)file, (Object)this.targetFile)) {
            return false;
        }
        this.targetFile = file;
        this.fireChanged();
        return true;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    protected void internalClear() {
        super.internalClear();
        this.sourceFile = null;
        this.targetFile = null;
    }

    public boolean isCleared() {
        if (!super.isCleared()) {
            return false;
        }
        if (this.sourceFile != null) {
            return false;
        }
        return this.targetFile == null;
    }

    protected IMessageProvider getSourceNotSelectedMessage() {
        return sourceNotSelected;
    }

    protected IMessageProvider getTargetNotSelectedMessage() {
        return targetNotSelected;
    }

    protected IMessageProvider getSourceDoesNotExistMessage() {
        return sourceDoesNotExist;
    }

    protected IMessageProvider getTargetDoesNotExistMessage() {
        return targetDoesNotExist;
    }

    protected IMessageProvider calculateMessage() {
        if (this.sourceFile == null) {
            return this.getSourceNotSelectedMessage();
        }
        if (!this.sourceFile.exists()) {
            return this.getSourceDoesNotExistMessage();
        }
        if (this.targetFile == null) {
            return this.getTargetNotSelectedMessage();
        }
        if (!this.targetFile.exists()) {
            return this.getTargetDoesNotExistMessage();
        }
        return super.calculateMessage();
    }
}

