/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescModel
extends AbstractViewModel
implements IDescModel,
IModelListener {
    private final SortedSet<IRep> reps;
    private final SortedSet<IRep> externalReps;
    private final IStoryModel model;
    private IDesc desc;
    private IMessageProvider defaultErrorMessage;

    public DescModel(IStoryModel model, IRep ... repArray) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (repArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.desc = this.getDefaultDesc();
        this.reps = new TreeSet<IRep>(Arrays.asList(repArray));
        this.externalReps = Collections.unmodifiableSortedSet(this.reps);
        this.model = model;
        this.model.addModelListener(this);
        this.defaultErrorMessage = new Message("A description must be selected", 3);
    }

    @Override
    public SortedSet<IRep> getReps() {
        return this.externalReps;
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.model;
    }

    @Override
    public IDesc getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc(IDesc newDesc) {
        if (this.desc == newDesc) {
            return;
        }
        if (newDesc != null && this.wrongType(newDesc)) {
            throw new IllegalArgumentException();
        }
        this.desc = newDesc;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public void setReps(Collection<IRep> newReps) {
        TreeSet<IRep> newRepSet = new TreeSet<IRep>(newReps);
        if (newRepSet.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.reps.equals(newRepSet)) {
            return;
        }
        this.reps.clear();
        this.reps.addAll(newRepSet);
        if (this.wrongType(this.desc)) {
            this.desc = null;
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    protected final boolean wrongType(IDesc desc) {
        for (IRep rep : this.reps) {
            if (!rep.isType(desc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDefaultErrorMessage(IMessageProvider defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage == null ? Message.NO_MESSAGE : defaultErrorMessage;
        this.setOutOfSync();
    }

    @Override
    protected void internalClear() {
        this.desc = this.getDefaultDesc();
    }

    @Override
    public boolean isCleared() {
        return this.desc == this.getDefaultDesc();
    }

    protected IDesc getDefaultDesc() {
        return null;
    }

    @Override
    protected IMessageProvider calculateMessage() {
        return this.desc == this.getDefaultDesc() ? this.defaultErrorMessage : Message.NO_MESSAGE;
    }

    @Override
    public void modelChanged(StoryChangeEvent e) {
        if (this.desc == null || e.affects(this.reps)) {
            return;
        }
        IDesc newDesc = this.model.getData().getDescription(this.desc.getID());
        if (newDesc != this.desc) {
            this.setDesc(newDesc);
        }
    }

    @Override
    public void dispose() {
        this.model.removeModelListener(this);
    }

    @Override
    public int getLength() {
        return this.desc == null ? -1 : this.desc.getLength();
    }

    @Override
    public int getOffset() {
        return this.desc == null ? -1 : this.desc.getOffset();
    }

    @Override
    public int getRightOffset() {
        return this.desc == null ? -1 : this.desc.getRightOffset();
    }
}

