/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.build;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.build.IBaseBuildRule;
import edu.mit.story.core.build.IBaseBuildRuleManager;
import edu.mit.story.core.manager.AbstractManager;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseBuildRuleManager<R extends IBaseBuildRule>
extends AbstractManager<R>
implements IBaseBuildRuleManager<R> {
    private final String extPoint;
    private Map<IRep, List<R>> ruleMap;

    public BaseBuildRuleManager(String extPoint) {
        if (extPoint.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.extPoint = extPoint;
    }

    @Override
    protected boolean doInit() {
        this.ruleMap = new HashMap<IRep, List<R>>();
        IBaseBuildRule rule = null;
        for (IConfigurationElement iConfigurationElement : BaseBuildRuleManager.getElements(this.extPoint, "rule")) {
            String id = iConfigurationElement.getAttribute("id");
            String name = iConfigurationElement.getAttribute("name");
            String desc = iConfigurationElement.getAttribute("description");
            String checkMsg = iConfigurationElement.getAttribute("checkedMessage");
            if (id == null || id.trim().length() == 0) {
                this.logError("A build rule may not have a null or empty id");
                continue;
            }
            if (name == null || name.trim().length() == 0) {
                this.logError("A build rule (id=" + id + ") may not have a null or empty name");
                continue;
            }
            if (checkMsg == null || checkMsg.trim().length() == 0) {
                this.logError("A build rule (id=" + id + ") may not have a null or empty checked message");
                continue;
            }
            try {
                rule = (IBaseBuildRule)iConfigurationElement.createExecutableExtension("class");
                rule.setID(id);
                rule.setName(name);
                rule.setDescription(desc);
                rule.setCheckedMessage(checkMsg);
            }
            catch (Exception ex) {
                Status status = new Status(4, "edu.mit.story.core", "", (Throwable)ex);
                StoryPlugin.getDefault().getLog().log((IStatus)status);
                continue;
            }
            this.registerDescriptor((R)rule);
        }
        for (Map.Entry entry : this.ruleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        return true;
    }

    @Override
    protected boolean registerDescriptor(R rule) {
        boolean success = super.registerDescriptor(rule);
        if (!success) {
            return false;
        }
        List<R> rules = this.ruleMap.get(rule.getRep());
        if (rules == null) {
            rules = new LinkedList<R>();
            this.ruleMap.put(rule.getRep(), rules);
        }
        rules.add(rule);
        return true;
    }

    @Override
    public List<R> getBuildRules(IRep rep) {
        List<R> result = this.ruleMap.get(rep);
        return result == null ? Collections.emptyList() : result;
    }

    protected final void logError(String msg) {
        Status status = new Status(4, "edu.mit.story.core", msg);
        StoryPlugin.getDefault().getLog().log((IStatus)status);
    }
}

