/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.tag.tagset.handlers.TagRepHandler;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.core.xml.IHasParserHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsetListener
implements IResourceChangeListener,
ISaveParticipant {
    private Multimap<IFile, IFile> tagsToModsMap = HashMultimap.create();
    private Map<IFile, IFile> modsToTagsMap = new HashMap<IFile, IFile>();
    public static final String MEMENTO_TYPE_PARENT = "links";
    public static final String MEMENTO_TYPE_CHILD = "link";
    public static final String MEMENTO_KEY_MODEL = "model";
    public static final String MEMENTO_KEY_TAGSET = "tagset";
    public static final String SAVE_BASENAME = "tagset-model-links";
    public static final IPath SAVE_BASENAME_PATH = new Path("tagset-model-links");

    public void resourceChanged(IResourceChangeEvent event) {
        final LinkedList modelsRemoved = new LinkedList();
        final LinkedList modelsModified = new LinkedList();
        final LinkedList tagsetsModified = new LinkedList();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource r = delta.getResource();
                        if (r.getType() != 1) {
                            return true;
                        }
                        IFile f = (IFile)r;
                        if (TagsetListener.isTagset(f)) {
                            tagsetsModified.add(f);
                        } else if (TagsetListener.isStoryModel(f)) {
                            switch (delta.getKind()) {
                                case 2: {
                                    modelsRemoved.add(f);
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    modelsModified.add(f);
                                }
                            }
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFile f : modelsRemoved) {
            this.modelRemoved(f);
        }
        for (IFile f : modelsModified) {
            this.modelModified(f);
        }
        final HashSet<IFile> modelsToBuild = new HashSet<IFile>();
        for (IFile f : tagsetsModified) {
            this.tagsetModified(f, modelsToBuild);
        }
        HashSet<IProject> ps = new HashSet<IProject>();
        for (IFile f : modelsToBuild) {
            ps.add(f.getProject());
        }
        if (ps.isEmpty()) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot rule = ps.size() > 1 ? workspace.getRoot() : (IContainer)ps.iterator().next();
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Marking resources for building", modelsToBuild.size());
                for (IFile f : modelsToBuild) {
                    f.touch((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.done();
            }
        };
        Job job = new Job("Tagset Build", (ISchedulingRule)rule){
            private final /* synthetic */ ISchedulingRule val$rule;
            {
                this.val$rule = iSchedulingRule;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, this.val$rule, 1, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "edu.mit.parsing.core", "Problem marking resources for build", (Throwable)e);
                    ParsingPlugin.getDefault().getLog().log((IStatus)status);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(40);
        job.schedule();
    }

    protected void modelRemoved(IFile model) {
        this.modsToTagsMap.remove(model);
        this.tagsToModsMap.values().remove(model);
    }

    protected void modelModified(IFile model) {
        TagRepHandler handler = new TagRepHandler();
        handler.setReportWarnings(false);
        XMLUtils.parse((IHasParserHandler)handler, (IFile)model);
        String pathStr = handler.getElement();
        if (pathStr == null) {
            IFile tagset = this.modsToTagsMap.get(model);
            if (tagset != null) {
                this.tagsToModsMap.remove((Object)tagset, (Object)model);
            }
        } else {
            Path path = new Path(pathStr);
            IFile newTagsetR = path.isAbsolute() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path) : model.getProject().getFile((IPath)path);
            IFile newTagset = newTagsetR instanceof IFile ? newTagsetR : null;
            IFile oldTagset = this.modsToTagsMap.remove(model);
            if (oldTagset != null) {
                this.tagsToModsMap.remove((Object)oldTagset, (Object)model);
            }
            if (newTagset != null) {
                this.modsToTagsMap.put(model, newTagset);
                this.tagsToModsMap.put((Object)newTagset, (Object)model);
            }
        }
    }

    protected void tagsetModified(IFile tagset, Set<IFile> modelsToBuild) {
        Collection models = this.tagsToModsMap.get((Object)tagset);
        modelsToBuild.addAll(models);
    }

    public static boolean isTagset(IFile r) {
        return r.getName().toLowerCase().endsWith(".tagset");
    }

    public static boolean isStoryModel(IFile r) {
        return r.getName().toLowerCase().endsWith(".sty");
    }

    protected void writeState(File f) throws CoreException {
        XMLMemento parent = XMLMemento.createWriteRoot((String)MEMENTO_TYPE_PARENT);
        for (Map.Entry<IFile, IFile> e : this.modsToTagsMap.entrySet()) {
            IMemento child = parent.createChild(MEMENTO_TYPE_CHILD);
            child.putString(MEMENTO_KEY_MODEL, e.getKey().getFullPath().toPortableString());
            child.putString(MEMENTO_KEY_TAGSET, e.getValue().getFullPath().toPortableString());
        }
        try {
            parent.save((Writer)new BufferedWriter(new FileWriter(f)));
        }
        catch (IOException e) {
            Status status = new Status(4, "edu.mit.parsing.core", "Problem writing to file " + f.getAbsolutePath(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void readState(File f) {
        this.modsToTagsMap.clear();
        this.tagsToModsMap.clear();
        XMLMemento parent = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader(f));
            try {
                parent = XMLMemento.createReadRoot((Reader)r);
            }
            catch (WorkbenchException e) {
                Status status = new Status(4, "edu.mit.parsing.core", "Problem reading memento from file " + f.getAbsolutePath(), (Throwable)e);
                ParsingPlugin.getDefault().getLog().log((IStatus)status);
                return;
            }
            ((Reader)r).close();
        }
        catch (IOException e) {
            Status status = new Status(4, "edu.mit.parsing.core", "Problem closing file " + f.getAbsolutePath(), (Throwable)e);
            ParsingPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento[] iMementoArray = parent.getChildren(MEMENTO_TYPE_CHILD);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile tagsetF;
            IMemento m = iMementoArray[n2];
            IResource styR = root.findMember((IPath)new Path(m.getString(MEMENTO_KEY_MODEL)));
            IFile tagsetR = root.getFile((IPath)new Path(m.getString(MEMENTO_KEY_TAGSET)));
            IFile styF = styR instanceof IFile ? (IFile)styR : null;
            IFile iFile = tagsetF = tagsetR instanceof IFile ? tagsetR : null;
            if (styF != null && tagsetF != null) {
                this.modsToTagsMap.put(styF, tagsetF);
                this.tagsToModsMap.put((Object)tagsetF, (Object)styF);
            }
            ++n2;
        }
    }

    protected static final String makeSaveFileName(String basename, int saveNumber) {
        return String.valueOf(basename) + '-' + Integer.toString(saveNumber);
    }

    public void load(ISavedState savedState) {
        if (savedState == null) {
            return;
        }
        IPath location = savedState.lookup(SAVE_BASENAME_PATH);
        if (location != null) {
            File savedStateFile = ParsingPlugin.getDefault().getStateLocation().append(location).toFile();
            this.readState(savedStateFile);
        }
        savedState.processResourceChangeEvents((IResourceChangeListener)this);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
        String saveFileName = TagsetListener.makeSaveFileName(SAVE_BASENAME, context.getSaveNumber());
        File savedStateFile = ParsingPlugin.getDefault().getStateLocation().append(saveFileName).toFile();
        this.writeState(savedStateFile);
        context.map(SAVE_BASENAME_PATH, (IPath)new Path(saveFileName));
        context.needSaveNumber();
    }

    public void doneSaving(ISaveContext context) {
        String oldFileName = TagsetListener.makeSaveFileName(SAVE_BASENAME, context.getPreviousSaveNumber());
        File f = ParsingPlugin.getDefault().getStateLocation().append(oldFileName).toFile();
        f.delete();
    }

    public void rollback(ISaveContext context) {
        String saveFileName = TagsetListener.makeSaveFileName(SAVE_BASENAME, context.getSaveNumber());
        File f = ParsingPlugin.getDefault().getStateLocation().append(saveFileName).toFile();
        f.delete();
    }
}

