/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.rules;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.Stem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.problems.InappropriateStemProblem;
import edu.mit.parsing.core.rep.stem.problems.MissingPOSTagProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlyOpenClassWordsStemmedRule
extends AbstractBuildRule {
    public OnlyOpenClassWordsStemmedRule() {
        super(StemRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> inappropriate = new HashSet<IDesc>();
        HashSet<IDesc> recalculate = new HashSet<IDesc>();
        IDescSet allTags = model.getData().getDescriptions(POSRep.getInstance());
        for (IDesc stemDesc : model.getData().getDescriptions(StemRep.getInstance())) {
            IPosTag pos;
            IStem stem = (IStem)stemDesc.getData();
            IDesc posDesc = stem.getPOS();
            if (posDesc == null) {
                posDesc = Stem.findMatchingPOS(stemDesc, stem.getWord(), allTags);
                if (posDesc == null) continue;
                recalculate.add(stemDesc);
            }
            if (StemRep.isStemmable(pos = (IPosTag)posDesc.getData())) continue;
            inappropriate.add(stemDesc);
        }
        if (inappropriate.isEmpty() && recalculate.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : inappropriate) {
            result.add((Object)new InappropriateStemProblem(d, this.getID()));
        }
        for (IDesc d : recalculate) {
            result.add((Object)new MissingPOSTagProblem(d, this.getID()));
        }
        return result;
    }
}

