/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.rules;

import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.problems.RedundantStemProblem;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformativeStemRule
extends AbstractBuildRule {
    public InformativeStemRule() {
        super(StemRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        LinkedList<IDesc> redundant = new LinkedList<IDesc>();
        IDescSet stemDescs = model.getData().getDescriptions(StemRep.getInstance());
        for (IDesc stemDesc : stemDescs) {
            String lemma;
            IStem stem = (IStem)stemDesc.getData();
            IBaseToken token = (IBaseToken)stem.getWord().getData();
            String surface = token.getSurface().toLowerCase();
            if (!surface.equals(lemma = stem.getStem())) continue;
            redundant.add(stemDesc);
        }
        if (redundant.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : redundant) {
            result.add((Object)new RedundantStemProblem(d, this.getID()));
        }
        return result;
    }
}

