/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IndexedStem;
import edu.mit.parsing.core.rep.stem.Stem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.Collection;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemDefaultFactory
extends AbstractDescFactory2<IndexedStem> {
    IStemmer fAlgorithm;

    public StemDefaultFactory() {
        super(StemRep.getInstance(), (Collection)StemRep.getInstance().getAntecedents());
    }

    protected boolean doInit(IStoryModel model) {
        String stemmerID = (String)this.getConfiguration().get((Object)"stemmer");
        if (stemmerID == null) {
            return false;
        }
        this.fAlgorithm = (IStemmer)ParsingPlugin.getDefault().getStemmerManager().create(stemmerID);
        if (this.fAlgorithm == null) {
            return false;
        }
        IConfiguration config = this.getConfiguration().getConfiguration("stemmer");
        if (config != null) {
            this.fAlgorithm.configure(config);
        }
        this.fAlgorithm.init();
        return true;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change tokenChange = event.getChange(TokenRep.getInstance());
        Change collocChange = event.getChange(CollocRep.getInstance());
        Change posChange = event.getChange(POSRep.getInstance());
        IHasPositionSet tokenRegions = tokenChange == null ? null : tokenChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet collocRegions = collocChange == null ? null : collocChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet posRegions = posChange == null ? null : posChange.getChanges((IFlag)Flag.DESCS);
        DistinctRegionSet result = new DistinctRegionSet();
        IDescSet tokenDescs = event.provider.getData().getDescriptions(TokenRep.getInstance());
        if (tokenRegions != null) {
            for (IHasPosition region : tokenRegions) {
                result.addAll((Collection)tokenDescs.openSet(region));
            }
        }
        if (collocRegions != null) {
            for (IHasPosition region : collocRegions) {
                result.addAll((Collection)tokenDescs.openSet(region));
            }
        }
        if (posRegions != null) {
            for (IHasPosition region : posRegions) {
                result.addAll((Collection)tokenDescs.openSet(region));
            }
        }
        return result;
    }

    protected IHasPositionSet<IndexedStem> calculateData(IHasPosition region, IStoryModel provider) {
        IDescSet tokens = provider.getData().getDescriptions(TokenRep.getInstance()).openSet(region);
        IDescSet collocs = provider.getData().getDescriptions(CollocRep.getInstance()).openSet(region);
        IDescSet tags = provider.getData().getDescriptions(POSRep.getInstance()).openSet(region);
        HasPositionSet result = new HasPositionSet();
        for (IDesc token : tokens) {
            this.stem(token, tags, (IHasPositionSet<IndexedStem>)result);
        }
        for (IDesc colloc : collocs) {
            this.stem(colloc, tags, (IHasPositionSet<IndexedStem>)result);
        }
        return result;
    }

    protected void stem(IDesc wordDesc, IDescSet posDescs, IHasPositionSet<IndexedStem> results) {
        for (IDesc p : posDescs.matchSet((IHasPosition)wordDesc)) {
            IPosTag posTag = (IPosTag)p.getData();
            if (posTag.getWord() != wordDesc || !StemRep.isStemmable(posTag)) continue;
            this.stem(p, results);
        }
    }

    protected void stem(IDesc posDesc, IHasPositionSet<IndexedStem> results) {
        String expanded;
        IPosTag tag = (IPosTag)posDesc.getData();
        IBaseToken word = (IBaseToken)tag.getWord().getData();
        String token = word.getToken();
        SortedSet<String> stems = this.fAlgorithm.getStems(token, tag.getTag());
        if (stems != null) {
            for (String stem : stems) {
                if (token.equalsIgnoreCase(stem) || "'".equals(stem)) continue;
                results.add((Object)new IndexedStem((IHasPosition)posDesc, new Stem(posDesc, stem)));
            }
        }
        if ((expanded = this.handleContractions(word, tag.getTag())) != null) {
            results.add((Object)new IndexedStem((IHasPosition)posDesc, new Stem(posDesc, expanded)));
        }
    }

    protected String handleContractions(IBaseToken token, ITag tag) {
        String surface = token.getSurface();
        if (surface.equalsIgnoreCase("n't")) {
            return "not";
        }
        if (!tag.isVerb()) {
            return null;
        }
        if (surface.equalsIgnoreCase("'d")) {
            return "have";
        }
        if (surface.equalsIgnoreCase("'ve")) {
            return "have";
        }
        if (surface.equalsIgnoreCase("'re")) {
            return "be";
        }
        if (surface.equalsIgnoreCase("'s")) {
            return "be";
        }
        if (surface.equalsIgnoreCase("'m")) {
            return "be";
        }
        if (surface.equalsIgnoreCase("'ll")) {
            return "be";
        }
        return null;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new StemFactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class StemFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public StemFactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public StemFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("stemmer", ParsingMessages.FACTORY_PARAM_NAME_Stemmer, ParsingMessages.FACTORY_PARAM_DESC_Stemmer, (IValidator)new ManagerBackedListValidator(ParsingPlugin.getDefault().getStemmerManager()), true, "DefaultStemmerID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

