/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.sentence.rules;

import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.sentence.problems.OverlappingSentencesProblem;
import edu.mit.parsing.core.rep.sentence.problems.UncoveredTokenProblem;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceCoverageRule
extends AbstractBuildRule {
    public static final String ID = SentenceCoverageRule.class.getCanonicalName();

    public SentenceCoverageRule() {
        super(SentenceRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet sds = model.getData().getDescriptions(SentenceRep.getInstance());
        IDescSet tds = model.getData().getDescriptions(TokenRep.getInstance());
        HashMap<IDesc, HashSet<IDesc>> tokenMap = new HashMap<IDesc, HashSet<IDesc>>(tds.size());
        for (IDesc td : tds) {
            tokenMap.put(td, null);
        }
        for (IDesc sd : sds) {
            ISentence s = (ISentence)sd.getData();
            for (IDesc iDesc : s.getDescs()) {
                HashSet<IDesc> sentSet = (HashSet<IDesc>)tokenMap.get(iDesc);
                if (sentSet == null) {
                    sentSet = new HashSet<IDesc>(1);
                    tokenMap.put(iDesc, sentSet);
                }
                sentSet.add(sd);
            }
        }
        HashSet<IDesc> uncovered = new HashSet<IDesc>();
        HashSet<Set> overlapping = new HashSet<Set>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            if (entry.getValue() == null) {
                uncovered.add((IDesc)entry.getKey());
                continue;
            }
            if (((Set)entry.getValue()).size() <= 1) continue;
            overlapping.add((Set)entry.getValue());
        }
        if (overlapping.isEmpty() && uncovered.isEmpty()) {
            return null;
        }
        HasPositionSet hasPositionSet = new HasPositionSet();
        if (this.isCompressing()) {
            hasPositionSet.add((Object)new UncoveredTokenProblem(uncovered, this.getID()));
        } else {
            for (IDesc d : uncovered) {
                hasPositionSet.add((Object)new UncoveredTokenProblem(d, this.getID()));
            }
        }
        for (Set ss : overlapping) {
            hasPositionSet.add((Object)new OverlappingSentencesProblem(ss, this.getID()));
        }
        return hasPositionSet;
    }
}

