/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos.rules;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.problems.AmbiguousPOSProblem;
import edu.mit.parsing.core.rep.pos.problems.UnknownPOSProblem;
import edu.mit.parsing.core.rep.pos.problems.UntaggedTokenProblem;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectivePOSTaggingRule
extends AbstractBuildRule {
    public InjectivePOSTaggingRule() {
        super(POSRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDesc tagDesc;
        LinkedHashMap<IDesc, IDescSet> results = new LinkedHashMap<IDesc, IDescSet>();
        IDescSet posDescs = model.getData().getDescriptions(POSRep.getInstance());
        for (IDesc d : model.getData().getDescriptions(TokenRep.getInstance())) {
            results.put(d, posDescs.matchSet((IHasPosition)d));
        }
        if (model.supports(CollocRep.getInstance())) {
            for (IDesc d : model.getData().getDescriptions(CollocRep.getInstance())) {
                results.put(d, posDescs.matchSet((IHasPosition)d));
            }
        }
        HashSet<IDesc> untaggedTokens = new HashSet<IDesc>();
        HashSet<IDescSet> ambiguousPOS = new HashSet<IDescSet>();
        HashSet<IDesc> unknownPOS = new HashSet<IDesc>();
        block6: for (Map.Entry entry : results.entrySet()) {
            switch (((IDescSet)entry.getValue()).size()) {
                case 0: {
                    untaggedTokens.add((IDesc)entry.getKey());
                    break;
                }
                case 1: {
                    tagDesc = (IDesc)((IDescSet)entry.getValue()).first();
                    IPosTag tag = (IPosTag)tagDesc.getData();
                    if (tag.getTag() != PennTag.UNKNOWN) continue block6;
                    unknownPOS.add(tagDesc);
                    break;
                }
                default: {
                    ambiguousPOS.add((IDescSet)entry.getValue());
                }
            }
        }
        Iterator i = unknownPOS.iterator();
        while (i.hasNext()) {
            tagDesc = (IDesc)i.next();
            IMetaDataSet checks = tagDesc.getMetaData().get((IMetaRep)CheckMetaRep.getInstance());
            if (checks == null || !checks.contains((Object)new MetaDesc((IMetaRep)CheckMetaRep.getInstance(), tagDesc, (IMetaData)new Check("edu.mit.parsing.core.problem.unknownPOS")))) continue;
            i.remove();
        }
        if (untaggedTokens.isEmpty() && ambiguousPOS.isEmpty() && unknownPOS.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        if (this.isCompressing()) {
            if (!untaggedTokens.isEmpty()) {
                result.add((Object)new UntaggedTokenProblem(untaggedTokens, this.getID()));
            }
            if (!ambiguousPOS.isEmpty()) {
                HashSet hashSet = new HashSet();
                for (IDescSet set : ambiguousPOS) {
                    hashSet.addAll(set);
                }
                result.add((Object)new AmbiguousPOSProblem(hashSet, this.getID()));
            }
            if (!unknownPOS.isEmpty()) {
                result.add((Object)new UnknownPOSProblem(unknownPOS, this.getID()));
            }
        } else {
            for (IDesc iDesc : untaggedTokens) {
                result.add((Object)new UntaggedTokenProblem(iDesc, this.getID()));
            }
            for (IDescSet iDescSet : ambiguousPOS) {
                result.add((Object)new AmbiguousPOSProblem((Collection<? extends IDesc>)iDescSet, this.getID()));
            }
            for (IDesc iDesc : unknownPOS) {
                result.add((Object)new UnknownPOSProblem(iDesc, this.getID()));
            }
        }
        return result;
    }
}

