/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards.pages;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.Pointer;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.util.ColorFontStyler;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import edu.mit.wordnet.core.rep.sense.evidence.IContextEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.IContextOverlap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class DefinitionViewer
extends Composite {
    public static final StyledString.Styler BOLD_STYLER = new ColorFontStyler(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"), StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"), 1);
    public static final StyledString.Styler CONTEXT_STYLER = new ColorFontStyler(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"), StoryUIPlugin.getDefault().getColorManager().get((Object)"GREEN"), 0);
    public static final StyledString.Styler CONTEXT_BOLD_STYLER = new ColorFontStyler(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"), StoryUIPlugin.getDefault().getColorManager().get((Object)"GREEN"), 1);
    public static final StyledString.Styler NOTICE_STYLER = new ColorFontStyler(StoryUIPlugin.getDefault().getColorManager().get((Object)"RED"), StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"), 0);
    protected static final StyledString noSenseMessage = new StyledString(String.valueOf('(') + IDisambiguationModel.AssignmentType.NO_SENSE.getMessage() + ')', NOTICE_STYLER);
    protected static final StyledString deleteMessage = new StyledString(String.valueOf('(') + IDisambiguationModel.AssignmentType.DELETE.getMessage() + ')', NOTICE_STYLER);
    protected static final StyledString skipMessage = new StyledString(String.valueOf('(') + IDisambiguationModel.AssignmentType.SKIP.getMessage() + ')', NOTICE_STYLER);
    private boolean showEvidence = false;
    private IDisambiguationModel.AssignmentType type = IDisambiguationModel.AssignmentType.NORMAL;
    private ISenseAssignment sense = null;
    private final StyledText text;
    private final IDictionary dict;

    public DefinitionViewer(Composite parent, int style, IDictionary dict) {
        super(parent, style);
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
        Color white = Display.getDefault().getSystemColor(25);
        this.setLayout((Layout)new GridLayout());
        this.setForeground(parent.getForeground());
        this.setBackground(white);
        this.text = new StyledText((Composite)this, 74);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setForeground(this.getForeground());
        this.text.setBackground(white);
    }

    public void setShowEvidence(boolean value) {
        if (this.showEvidence == value) {
            return;
        }
        this.showEvidence = value;
        this.updateFromModel();
    }

    public boolean isShowingEvidence() {
        return this.showEvidence;
    }

    public void setAssignmentType(IDisambiguationModel.AssignmentType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.updateFromModel();
    }

    public void setInput(ISenseAssignment sense) {
        if (this.sense == sense) {
            return;
        }
        this.sense = sense;
        this.updateFromModel();
    }

    public ISenseAssignment getInput() {
        return this.sense;
    }

    protected void updateFromModel() {
        StyledString sb = this.getTextFromModel();
        this.text.setText(sb.toString());
        this.text.setStyleRanges(sb.getStyleRanges());
    }

    protected StyledString getTextFromModel() {
        switch (this.type) {
            case NO_SENSE: {
                return noSenseMessage;
            }
            case DELETE: {
                return deleteMessage;
            }
            case SKIP: {
                return skipMessage;
            }
        }
        if (this.sense == null) {
            return new StyledString();
        }
        ISenseAssignment sense = this.getInput();
        if (sense.getSense() == null) {
            return noSenseMessage;
        }
        StyledString sb = new StyledString();
        this.appendSynsetText(sb, sense.getSense().getSynset(), sense);
        List hyperIDs = sense.getSense().getSynset().getRelatedSynsets((IPointer)Pointer.HYPERNYM);
        for (ISynsetID hyperID : hyperIDs) {
            ISynset hypernym = this.dict.getSynset(hyperID);
            if (hypernym == null) continue;
            sb.append("\n\nParent:\n", BOLD_STYLER);
            this.appendSynsetText(sb, hypernym, null);
        }
        return sb;
    }

    protected void appendSynsetText(StyledString sb, ISynset synset, ISenseAssignment sense) {
        LinkedList<IWord> synonyms;
        IWord word = null;
        IContextEvidence ce = null;
        if (sense != null) {
            word = sense.getSense();
            if (sense.getEvidence() instanceof IContextEvidence) {
                ce = (IContextEvidence)sense.getEvidence();
            }
        }
        if ((synonyms = new LinkedList<IWord>(synset.getWords())).remove(word)) {
            synonyms.add(0, word);
        }
        HashSet<IWord> highlight = new HashSet<IWord>();
        if (ce != null && this.showEvidence) {
            for (IContextOverlap overlap : ce.getContextOverlaps()) {
                if (overlap.getWordNumber() <= 0) continue;
                highlight.add(synset.getWord(overlap.getWordNumber()));
            }
        }
        Iterator i = synonyms.iterator();
        while (i.hasNext()) {
            IWord synonym = (IWord)i.next();
            sb.append(synonym.getLemma(), highlight.contains(synonym) ? CONTEXT_BOLD_STYLER : BOLD_STYLER);
            if (!i.hasNext()) continue;
            sb.append(", ", BOLD_STYLER);
        }
        if (word != null) {
            sb.append(" (" + word.getSenseKey().toString() + ')');
        }
        sb.append('\n');
        int glossOffset = sb.length();
        sb.append(synset.getGloss());
        if (ce != null && this.showEvidence) {
            for (IContextOverlap overlap : ce.getContextOverlaps()) {
                if (overlap.getWordNumber() >= 1) continue;
                sb.setStyle(glossOffset + overlap.getOffset(), overlap.getLength(), CONTEXT_STYLER);
            }
        }
    }
}

