/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards;

import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.util.Debug;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.core.rep.sense.changes.DisambiguationChange;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.wizards.pages.DisambiguationPage;
import edu.mit.wordnet.ui.wizards.pages.WSDFinishPage;
import edu.mit.wordnet.ui.wizards.pages.WSDPresentationOrderPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDWizardDialog
extends WizardDialog {
    List<IDisambiguationModel> models;

    public WSDWizardDialog(IStoryEditor editor, List<IDisambiguationModel> models) {
        super(editor.getEditorSite().getShell(), (IWizard)new WSDWizard(editor, models));
        this.models = new ArrayList<IDisambiguationModel>(models);
    }

    public void backPressed() {
        IWizardPage currPage = this.getCurrentPage();
        if (currPage instanceof DisambiguationPage) {
            DisambiguationPage wsdPage = (DisambiguationPage)currPage;
            wsdPage.getController().stopTimer();
            IDisambiguationModel model = wsdPage.getController().getModel();
            int index = this.models.indexOf(model);
            if (index <= 0) {
                super.backPressed();
                return;
            }
            model = this.models.get(index - 1);
            wsdPage.setModel(model);
            return;
        }
        IWizardPage prevPage = currPage.getPreviousPage();
        if (prevPage instanceof DisambiguationPage) {
            Debug.err();
        }
        super.backPressed();
    }

    public void nextPressed() {
        IWizardPage currPage = this.getCurrentPage();
        if (currPage instanceof DisambiguationPage) {
            DisambiguationPage wsdPage = (DisambiguationPage)currPage;
            wsdPage.getController().stopTimer();
            int index = this.models.indexOf(wsdPage.getController().getModel());
            int count = this.countActiveModels();
            if (index < count - 1) {
                wsdPage.setModel(this.models.get(index + 1));
                return;
            }
            super.nextPressed();
            return;
        }
        IWizardPage nextPage = currPage.getNextPage();
        if (nextPage instanceof DisambiguationPage) {
            DisambiguationPage wsdPage = (DisambiguationPage)nextPage;
            wsdPage.setModel(this.models.get(0));
        }
        super.nextPressed();
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        if (page instanceof DisambiguationPage) {
            ((DisambiguationPage)page).setKeyboardFocusToTable();
        }
    }

    public boolean close() {
        IWizardPage currPage = this.getCurrentPage();
        if (currPage instanceof DisambiguationPage) {
            DisambiguationPage page = (DisambiguationPage)currPage;
            page.getController().stopTimer();
        }
        return super.close();
    }

    protected void handleShellCloseEvent() {
        if (!this.confirmCancel()) {
            return;
        }
        super.handleShellCloseEvent();
    }

    protected void cancelPressed() {
        if (!this.confirmCancel()) {
            return;
        }
        super.cancelPressed();
    }

    protected boolean confirmCancel() {
        String title = "Confirm Cancel";
        String message = "Are you sure you want to cancel?  You will lose all work done up to this point.";
        String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, labels, 1);
        return dialog.open() == 0;
    }

    public static void open(IStoryEditor editor) {
        WSDWizardDialog.open(editor, (IDescMultiSet)editor.getStoryModel().getData());
    }

    public static void open(IStoryEditor editor, IDescMultiSet source) {
        List<IDisambiguationModel> items = Collections.emptyList();
        if (items == null || items.isEmpty()) {
            MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)"WSD Wizard", (String)"There are no words to disambiguate");
            return;
        }
        WSDWizardDialog dialog = new WSDWizardDialog(editor, items);
        dialog.setBlockOnOpen(false);
        dialog.setPageSize(800, 800);
        dialog.open();
    }

    protected int countActiveModels() {
        int count = 0;
        for (IDisambiguationModel model : this.models) {
            if (model.isSubsumed()) continue;
            ++count;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WSDWizard
    extends Wizard {
        IStoryEditor editor;
        List<IDisambiguationModel> models;

        public WSDWizard(IStoryEditor editor, List<IDisambiguationModel> models) {
            if (editor == null) {
                throw new IllegalArgumentException();
            }
            this.editor = editor;
            this.models = models;
            this.setWindowTitle(WordnetUIMessages.WIZARD_WSD_title);
            this.setNeedsProgressMonitor(false);
            this.addPage((IWizardPage)new WSDPresentationOrderPage(models));
            this.addPage((IWizardPage)new DisambiguationPage(null, editor));
            this.addPage((IWizardPage)new WSDFinishPage());
        }

        public boolean performFinish() {
            IWizardPage currPage = this.getContainer().getCurrentPage();
            if (currPage instanceof DisambiguationPage) {
                DisambiguationPage page = (DisambiguationPage)currPage;
                page.getController().stopTimer();
            }
            LinkedList<DisambiguationChange> changes = new LinkedList<DisambiguationChange>();
            for (IDisambiguationModel model : this.models) {
                if (!model.isDisambiguated()) continue;
                changes.add(new DisambiguationChange(model));
            }
            if (!changes.isEmpty()) {
                CompositeModelChange change = new CompositeModelChange(changes);
                this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
            }
            return true;
        }
    }
}

