/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards;

import edu.mit.parsing.core.util.IWordInfo;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.ops.CreateFileOperation;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.ui.wizards.pages.ExportWSDDataPage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportWSDDataWizard
extends Wizard
implements IExportWizard {
    ExportWSDDataPage exportPage;
    public static final int COL_offset = 10;
    public static final int COL_length = 10;
    public static final int COL_surface = 40;
    public static final int COL_pos = 15;
    public static final int COL_stem = 40;
    public static final int COL_cnt = 15;
    public static final int COL_word = 40;
    public static final int COL_time = 20;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.exportPage = new ExportWSDDataPage();
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean performFinish() {
        IPath sourceFile = this.exportPage.getSourceFile();
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(sourceFile);
        InputStreamReader r = new InputStreamReader(CreateFileOperation.getContent((IPath)this.exportPage.getSourceFile()));
        StoryModelImporter importer = new StoryModelImporter();
        IMutableStoryModel model = importer.importFromXML((Reader)r, ifile.getProject().getName());
        String content = this.getContent((IStoryModel)model);
        IPath target = this.exportPage.getExportFile();
        File file = target.toFile();
        try {
            file.createNewFile();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            os.write(content.getBytes());
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getContent(IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    protected void addHeader(StringBuilder sb, boolean useData) {
        this.addFixed("Offset", 10, sb);
        this.addFixed("Length", 10, sb);
        this.addFixed("Surface", 40, sb);
        this.addFixed("POS", 15, sb);
        this.addFixed("Stem", 40, sb);
        this.addFixed("Count", 15, sb);
        this.addFixed("Word", 40, sb);
        if (useData) {
            this.addFixed("Time", 20, sb);
        }
        sb.append('\n');
    }

    protected void add(IHasPosition p, IWordInfo info, ISense sense, StringBuilder sb) {
    }

    protected void addFixed(String str, int length, StringBuilder sb) {
        int expected = sb.length() + Math.max(str == null ? 0 : str.length(), length);
        if (str != null) {
            sb.append(str);
        }
        while (sb.length() < expected) {
            sb.append(' ');
        }
    }
}

