/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.views;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.actions.FocusOnSynsetAction;
import edu.mit.wordnet.ui.content.SynsetContentProvider;
import edu.mit.wordnet.ui.label.SynsetLabelProvider;
import edu.mit.wordnet.ui.views.SynsetHierarchyViewPart;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPropertyListener;

public class SynsetHierarchyPage
extends Composite
implements IPropertyListener {
    int fDefaultExpandLevel = 2;
    SynsetHierarchyViewPart parentPart;
    MenuManager fMenuManager;
    ISynset fSynset;
    GridLayout fLayout;
    Label fLabel;
    TreeViewer fViewer;
    SynsetLabelProvider fLabelProvider;
    SynsetContentProvider fContentProvider;
    IAction fFocusOnSynsetAction;
    boolean fUpdated = true;

    public SynsetHierarchyPage(ISynset synset, SynsetHierarchyViewPart part, int style) {
        super((Composite)part.getPageBook(), style);
        if (part == null) {
            throw new NullPointerException();
        }
        this.parentPart = part;
        this.fLabelProvider = part.getLabelProvider();
        this.fContentProvider = part.getContentProvider();
        this.fLabelProvider.addPropertyListener(this);
        this.fContentProvider.addPropertyListener(this);
        this.fSynset = synset;
        this.createControl();
        this.createActions();
    }

    public void dispose() {
        this.fLabelProvider.removePropertyListener(this);
        this.fContentProvider.removePropertyListener(this);
        this.fLabelProvider = null;
        this.fContentProvider = null;
        this.fSynset = null;
        this.fFocusOnSynsetAction = null;
        this.parentPart = null;
        this.fMenuManager.dispose();
        super.dispose();
    }

    protected void createActions() {
        this.fFocusOnSynsetAction = new FocusOnSynsetAction(this.parentPart);
        this.fMenuManager = new MenuManager();
        this.fMenuManager.add((IContributionItem)new GroupMarker("focus.ext"));
        this.fMenuManager.add(this.fFocusOnSynsetAction);
        this.fMenuManager.add((IContributionItem)new Separator());
        this.fMenuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = this.fMenuManager.createContextMenu((Control)this);
        this.setMenu(menu);
        String menuID = "edu.mit.wordnet.synsetHierarchy.popup_" + (this.fSynset != null ? ((ISynsetID)this.fSynset.getID()).toString() : "default");
        this.parentPart.getSite().registerContextMenu(menuID, this.fMenuManager, (ISelectionProvider)this.getTreeViewer());
    }

    public void createControl() {
        this.fLayout = new GridLayout();
        this.fLayout.numColumns = 1;
        this.fLayout.marginWidth = 0;
        this.fLayout.marginHeight = 0;
        this.fLayout.verticalSpacing = 0;
        this.setLayout((Layout)this.fLayout);
        this.fLabel = new Label((Composite)this, 16576);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.fLabel.setLayoutData((Object)data);
        this.updateLabel();
        if (this.fSynset != null) {
            if (this.fViewer == null) {
                this.fViewer = new TreeViewer((Composite)this, 772);
                this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
                this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                this.fViewer.getTree().setLayoutData((Object)data);
            }
            this.fViewer.setInput((Object)this);
            this.fViewer.expandToLevel(this.fDefaultExpandLevel);
        }
    }

    public void updateLabel() {
        if (this.fSynset == null) {
            this.fLabel.setText(WordnetUIMessages.MSG_VIEW_NoSynsetHierarchy);
        } else {
            this.fLabel.setText(this.fLabelProvider.getText(this.fSynset));
        }
    }

    public ISynset getInput() {
        return this.fSynset;
    }

    public boolean isUpdated() {
        return this.fUpdated;
    }

    public void setUpdated(boolean value) {
        this.fUpdated = value;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer != null ? this.fViewer : null;
    }

    public void refresh() {
        if (this.fUpdated) {
            return;
        }
        this.updateLabel();
        this.getTreeViewer().refresh();
        this.getTreeViewer().expandToLevel(this.fDefaultExpandLevel);
        this.setUpdated(true);
    }

    public SynsetContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public SynsetLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected void refreshContents() {
    }

    public boolean setFocus() {
        if (this.fViewer != null) {
            return this.fViewer.getControl().setFocus();
        }
        return super.setFocus();
    }

    public void setMenu(Menu menu) {
        if (this.fViewer != null) {
            this.fViewer.getTree().setMenu(menu);
            return;
        }
        super.setMenu(menu);
    }

    public void propertyChanged(Object source, int propID) {
        if (source != this.fLabelProvider & source != this.fContentProvider) {
            return;
        }
        this.setUpdated(false);
    }
}

