/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.label;

import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class WSDItemTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int IDX_Token = 0;
    public static final int IDX_Stem = 1;
    public static final int IDX_Tag = 2;
    public static final int IDX_TagName = 3;
    public static final int IDX_NumSenses = 4;
    public static final int IDX_Position = 5;

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IDisambiguationModel) {
            IDisambiguationModel item = (IDisambiguationModel)element;
            switch (columnIndex) {
                case 0: {
                    return item.getModelInfo().getBaseToken().getSurface();
                }
                case 1: {
                    return item.getModelInfo().isRoot() ? null : item.getModelInfo().getBaseForm();
                }
                case 2: {
                    return item.getModelInfo().getPosTag().getTag().getTagString();
                }
                case 3: {
                    return item.getModelInfo().getPosTag().getTag().getName();
                }
                case 4: {
                    return Integer.toString(item.getSenses().size());
                }
                case 5: {
                    return String.valueOf(item.getOffset()) + "-" + item.getRightOffset();
                }
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

