/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui;

import edu.mit.jwi.item.POS;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Set;

public final class WordnetUIUtils
implements IUtilityClass {
    private WordnetUIUtils() {
    }

    public static boolean canChooseSense(IHasPosition p, IStoryData data) {
        if (data == null || !data.supports(SenseRep.getInstance())) {
            return false;
        }
        IDesc token = ParsingUtils.getToken((IHasPosition)p, (IStoryData)data);
        if (token == null) {
            return false;
        }
        Set senses = WordnetUtils.extractSenses((IHasPosition)token, (IStoryData)data);
        return senses.size() > 1;
    }

    public static String getIconGIFImageKey(POS pos) {
        if (pos == null) {
            return null;
        }
        if (pos == POS.NOUN) {
            return "obj16/noun.gif";
        }
        if (pos == POS.VERB) {
            return "obj16/verb.gif";
        }
        if (pos == POS.ADJECTIVE) {
            return "obj16/adjective.gif";
        }
        if (pos == POS.ADVERB) {
            return "obj16/adverb.gif";
        }
        return null;
    }

    public static String getIconPNGImageKey(POS pos) {
        if (pos == null) {
            return null;
        }
        if (pos == POS.NOUN) {
            return "obj16/noun.png";
        }
        if (pos == POS.VERB) {
            return "obj16/verb.png";
        }
        if (pos == POS.ADJECTIVE) {
            return "obj16/adjective.png";
        }
        if (pos == POS.ADVERB) {
            return "obj16/adjective.png";
        }
        return null;
    }
}

