/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relation;

import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.ui.relation.ArgumentProxy;
import edu.mit.discourse.ui.relation.LexicalMarkerProxy;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.util.IClearable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationProxy
extends ChangeNotifier
implements IRelation,
INotifyingMessageProvider,
ChangeListener,
IClearable {
    ListenerList listeners = new ListenerList();
    public final LexicalMarkerProxy lexMarker;
    public final ArgumentProxy argOne;
    public final ArgumentProxy argTwo;
    public final List<ArgumentProxy> additionalArgs = new ArrayList<ArgumentProxy>();
    public final List<IProperty> props = new ArrayList<IProperty>();

    public RelationProxy() {
        this.lexMarker = new LexicalMarkerProxy("Lexical Marker");
        this.argOne = new ArgumentProxy("Argument One");
        this.argTwo = new ArgumentProxy("Argument Two");
        this.lexMarker.addChangeListener(this);
        this.argOne.addChangeListener(this);
        this.argTwo.addChangeListener(this);
    }

    public void load(IRelation r, IStoryData data) {
        this.clear();
        if (r != null) {
            LexicalMarkerProxy lm = LexicalMarkerProxy.convert(r.getLexicalMarker(), data);
            this.lexMarker.load(lm, data);
            ArgumentProxy arg = ArgumentProxy.convert((IArgument)r.getArguments().get(0), data);
            this.argOne.load(arg, data);
            arg = ArgumentProxy.convert((IArgument)r.getArguments().get(0), data);
            this.argTwo.load(arg, data);
            int i = 2;
            while (i < r.getArguments().size()) {
                arg = ArgumentProxy.convert((IArgument)r.getArguments().get(0), data);
                this.additionalArgs.add(arg);
                ++i;
            }
        }
    }

    public boolean isSet() {
        if (!this.additionalArgs.isEmpty()) {
            return true;
        }
        if (!this.lexMarker.getAdjuncts().isEmpty()) {
            return true;
        }
        if (!this.argOne.getAdjuncts().isEmpty()) {
            return true;
        }
        return !this.argTwo.getAdjuncts().isEmpty();
    }

    public LexicalMarkerProxy getLexicalMarker() {
        return this.lexMarker;
    }

    public ArgumentProxy getArgumentOne() {
        return this.argOne;
    }

    public ArgumentProxy getArgumentTwo() {
        return this.argTwo;
    }

    public List<ArgumentProxy> getAdditionalArgs() {
        return this.additionalArgs;
    }

    public void addArgument(Collection<ISegment> tokens, boolean makeReferent, IStoryData data) {
        int count = this.additionalArgs.size();
        String name = "Argument " + ++count;
        ArgumentProxy proxy = new ArgumentProxy(name, tokens, makeReferent, data);
        proxy.addChangeListener(this);
        this.additionalArgs.add(proxy);
    }

    public List<IArgument> getArguments() {
        ArrayList<IArgument> result = new ArrayList<IArgument>(2 + this.additionalArgs.size());
        result.add(this.argOne);
        result.add(this.argTwo);
        result.addAll(this.additionalArgs);
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.notifyChangeListeners(event);
    }

    public String getDisplayText() {
        return this.lexMarker.getDisplayText();
    }

    public boolean validate() {
        boolean valid = this.lexMarker.validate() && this.argOne.validate() && this.argTwo.validate();
        for (ArgumentProxy arg : this.additionalArgs) {
            valid &= arg.validate();
        }
        return valid;
    }

    public String getMessage() {
        if (!this.lexMarker.validate()) {
            return this.lexMarker.getMessage();
        }
        if (!this.argOne.validate()) {
            return this.argOne.getMessage();
        }
        if (!this.argTwo.validate()) {
            return this.argTwo.getMessage();
        }
        for (ArgumentProxy arg : this.additionalArgs) {
            if (arg.validate()) continue;
            return arg.getMessage();
        }
        return null;
    }

    public int getMessageType() {
        return 0;
    }

    public void clear() {
        this.lexMarker.clear();
        this.argOne.clear();
        this.argTwo.clear();
        this.additionalArgs.clear();
        this.props.clear();
        this.notifyChangeListeners();
    }

    public boolean isCleared() {
        return this.lexMarker.isCleared() && this.argOne.isCleared() && this.argTwo.isCleared() && this.additionalArgs.isEmpty() && this.props.isEmpty();
    }

    public List<IProperty> getProperties() {
        return this.props;
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public RelationProxy clone() {
        throw new UnsupportedOperationException();
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public RelationProxy recalculate(IDesc container, IStoryModel provider) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }
}

