/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CoreferenceLabelProvider
extends StoryModelLabelProvider {
    private Image corefImg;
    private Image refexpImg;

    public CoreferenceLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        if (data instanceof IDescModel) {
            IDescModel model = (IDescModel)data;
            data = model.getDesc();
        }
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc d = (IDesc)data;
            data = d.getData();
            id = d.getID();
        }
        if (data instanceof ICoref) {
            ICoref coref = (ICoref)data;
            StyledString result = new StyledString();
            result.append(coref.getName());
            CoreferenceLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                CoreferenceLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        if (data instanceof IRefExp) {
            IRefExp refexp = (IRefExp)data;
            StyledString result = new StyledString();
            result.append(refexp.getDisplayText());
            return CoreferenceLabelProvider.appendID((StyledString)result, (long)id);
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDescModel) {
            IDescModel model = (IDescModel)element;
            element = model.getDesc();
        }
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            element = d.getData();
        }
        if (element instanceof ICoref) {
            return this.getCorefImage();
        }
        if (element instanceof IRefExp) {
            return this.getRegexpImage();
        }
        return super.getImage(element);
    }

    protected Image getCorefImage() {
        if (this.corefImg == null) {
            this.corefImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/referent.gif");
        }
        return this.corefImg;
    }

    protected Image getRegexpImage() {
        if (this.refexpImg == null) {
            this.refexpImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/reference.gif");
        }
        return this.refexpImg;
    }
}

