/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.core.compare.ScoredElement;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.parsing.ui.ParsingUIPlugin;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    Image argImg;
    Image lmImg;
    Image relImg;
    Image segImg;
    public List<String> columnHeadings;

    public ComparisonTreeLabelProvider(List<String> columnHeadings) {
        this.columnHeadings = columnHeadings;
    }

    public Image getImage(Object element) {
        return null;
    }

    protected Image getArgumentImage() {
        if (this.argImg == null) {
            this.argImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/argument.gif");
        }
        return this.argImg;
    }

    protected Image getRelationImage() {
        if (this.relImg == null) {
            this.relImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/relation.gif");
        }
        return this.relImg;
    }

    protected Image getLexicalImage() {
        if (this.lmImg == null) {
            this.lmImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/lexmarker.gif");
        }
        return this.lmImg;
    }

    protected Image getSegmentImage() {
        if (this.segImg == null) {
            this.segImg = ParsingUIPlugin.getDefault().getImageRegistry().get("obj16/sentence.gif");
        }
        return this.segImg;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.columnHeadings.get(columnIndex).equals("Type")) {
            Assert.isLegal((boolean)(element instanceof ScoredElement));
            String type = ((ScoredElement)element).getProperty("Type");
            if (type == null) {
                return null;
            }
            if (type.equals("Story")) {
                return null;
            }
            if (type.equals("Relation")) {
                return this.getRelationImage();
            }
            if (type.equals("Lexical Marker")) {
                return this.getLexicalImage();
            }
            if (type.equals("Argument")) {
                return this.getArgumentImage();
            }
            if (type.equals("Segment")) {
                return this.getSegmentImage();
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String propertyKey = this.columnHeadings.get(columnIndex);
        String propertyVal = ((ScoredElement)element).getProperty(propertyKey);
        if (propertyVal == null) {
            return "";
        }
        return propertyVal;
    }
}

