/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.hovers;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.Iterator;

public class RefExpHover
extends StoryTextHover {
    public RefExpHover() {
        super(RefExpRep.getInstance());
    }

    public String getHoverInfo(IStoryModel editor, int hoverOffset, IHasPosition selection) {
        if (!editor.supports(RefExpRep.getInstance())) {
            return null;
        }
        IDescSet refexpDescs = editor.getData().getDescriptions(RefExpRep.getInstance()).closedSet((IHasPosition)new SimplePosition(hoverOffset, 0));
        if (refexpDescs.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Referential Expressions:\n");
        Iterator i = refexpDescs.iterator();
        while (i.hasNext()) {
            IDesc d = (IDesc)i.next();
            IRefExp refexp = (IRefExp)d.getData();
            sb.append(refexp.getDisplayText());
            sb.append(" (");
            sb.append(Long.toString(d.getID()));
            sb.append(')');
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

