/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.helpers;

import edu.mit.discourse.core.rep.referent.model.IReferenceModel;
import edu.mit.discourse.core.rep.referent.model.IReferentModel;
import edu.mit.discourse.ui.content.ReferentContentProvider;
import edu.mit.discourse.ui.controllers.IReferentController;
import edu.mit.discourse.ui.controllers.ReferentController;
import edu.mit.discourse.ui.label.ReferentLabelProvider;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class ReferentCreatorPage
extends HelperPage
implements ChangeListener,
ICreatorPage,
IAdaptable {
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Reference";
    public static String buttonLabelSaveArg = "Save Reference";
    public static String actionLabelCommit = "Commit Referent";
    public static String actionLabelSave = "Save Referent";
    public static String actionLabelClear = "Clear Referent";
    public static String actionLabelCancel = "Cancel Edit";
    public static String actionLabelCommitArg = "Commit Reference";
    public static String actionLabelSaveArg = "Save Changes in Reference";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new reference", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this referent to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this referent in the story model", 1);
    public static IMessageProvider addArgMessage = new Message("Press the 'commit reference' button to add this reference to the referent", 2);
    public static IMessageProvider saveArgMessage = new Message("Press the 'save reference' button to change this reference", 2);
    protected IReferentController controller;
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected Text nameWidget;
    protected SegmentSetCaptureWidget<ISegmentSetController> refWidget;
    protected TreeViewer refViewer;
    protected Button commitRefButton;
    protected Button addByPatternButton;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitRefAction;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.controller = new ReferentController(this.getStoryEditor(), "edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2");
        this.messageManager = new MessageProviderManager((ChangeListener)this);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getReferentModel());
        this.messageManager.add((INotifyingMessageProvider)this.controller.getReferenceController().getModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        int numColumns = 1;
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false, numColumns, 1));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false, numColumns, 1));
        SashForm sash = new SashForm(control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite widgetParent = new Composite((Composite)sash, 0);
        widgetParent.setLayoutData((Object)new GridData(4, 128, true, false));
        widgetParent.setBackground(control.getBackground());
        widgetParent.setForeground(control.getForeground());
        numColumns = 2;
        widgetParent.setLayout((Layout)new GridLayout(numColumns, false));
        Label label = new Label(widgetParent, 0);
        label.setBackground(widgetParent.getBackground());
        label.setForeground(widgetParent.getForeground());
        label.setText("Name");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.nameWidget = new Text(widgetParent, 2052);
        this.nameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReferentCreatorPage.this.controller.setName(ReferentCreatorPage.this.nameWidget.getText());
            }
        });
        this.nameWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(widgetParent, 0);
        label.setBackground(widgetParent.getBackground());
        label.setForeground(widgetParent.getForeground());
        label.setText("Reference");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refWidget = new SegmentSetCaptureWidget(widgetParent, 0, (ISegmentSetController)this.controller.getReferenceController());
        this.refWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refWidget.getAddAction().setText("Add to Reference");
        this.refWidget.getAddAction().setToolTipText("Add to Reference");
        this.refWidget.getSubtractAction().setText("Subtract from Reference");
        this.refWidget.getSubtractAction().setToolTipText("Subtract from Reference");
        this.refWidget.getClearAction().setText("Clear Reference");
        this.refWidget.getClearAction().setToolTipText("Clear Reference");
        label = new Label(widgetParent, 0);
        label.setBackground(widgetParent.getBackground());
        label.setForeground(widgetParent.getForeground());
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite refButtons = new Composite(widgetParent, 0);
        refButtons.setBackground(widgetParent.getBackground());
        refButtons.setForeground(widgetParent.getForeground());
        refButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        refButtons.setLayout((Layout)layout);
        this.commitRefButton = new Button(refButtons, 0);
        this.commitRefButton.setText("Commit Reference");
        this.commitRefAction = new ButtonAction(this.commitRefButton){

            public void run() {
                ReferentCreatorPage.this.controller.addReference();
            }
        };
        this.commitRefAction.setToolTipText("Commit Reference to Referent");
        this.addByPatternButton = new Button(refButtons, 0);
        this.addByPatternButton.setText("Add by Pattern...");
        this.addByPatternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferentCreatorPage.this.controller.addReferencesByPattern();
            }
        });
        label = new Label(refButtons, 0);
        label.setBackground(refButtons.getBackground());
        label.setForeground(refButtons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(widgetParent, 0);
        label.setBackground(widgetParent.getBackground());
        label.setForeground(widgetParent.getForeground());
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite lowerButtons = new Composite(widgetParent, 0);
        lowerButtons.setBackground(widgetParent.getBackground());
        lowerButtons.setForeground(widgetParent.getForeground());
        lowerButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        lowerButtons.setLayout((Layout)layout);
        label = new Label(lowerButtons, 0);
        label.setBackground(refButtons.getBackground());
        label.setForeground(refButtons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(lowerButtons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                ReferentCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(lowerButtons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                ReferentCreatorPage.this.controller.clear();
            }
        };
        this.refViewer = new TreeViewer((Composite)sash, 2048);
        this.refViewer.setContentProvider((IContentProvider)new ReferentContentProvider(this.getStoryEditor()));
        this.refViewer.setLabelProvider((IBaseLabelProvider)new ReferentLabelProvider(this.getStoryEditor()));
        this.refViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.controller.getReferentModel()}));
        this.refViewer.addSelectionChangedListener((ISelectionChangedListener)this.controller.getActionEdit());
        this.refViewer.addSelectionChangedListener((ISelectionChangedListener)this.controller.getActionDelete());
        sash.setWeights(new int[]{3, 1});
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        manager.appendToGroup("group.edit", (IAction)this.controller.getActionEdit());
        manager.appendToGroup("group.edit", (IAction)this.controller.getActionDelete());
        Tree tree = this.refViewer.getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.updateFromModel();
    }

    public void setActionBars(IActionBars actionBars) {
        this.getController().getUndoRedoActionGroup().fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.getController().getActionDelete());
        this.refWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.refWidget.getAddAction().getActionDefinitionId(), this.refWidget.getAddAction());
        this.refWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        actionBars.setGlobalActionHandler(this.refWidget.getSubtractAction().getActionDefinitionId(), this.refWidget.getSubtractAction());
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        this.commitRefAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.1");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        actionBars.setGlobalActionHandler(this.commitRefAction.getActionDefinitionId(), (IAction)this.commitRefAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        this.refWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        actionBars.setGlobalActionHandler(this.refWidget.getClearAction().getActionDefinitionId(), this.refWidget.getClearAction());
    }

    protected void updateFromModel() {
        String commitRefActionLabel;
        IMessageProvider addArgMsg;
        IReferentModel model = this.controller.getReferentModel();
        IReferenceModel refModel = this.controller.getReferenceController().getModel();
        boolean isMainLoaded = model.getLoaded() != null;
        boolean isRefLoaded = refModel.getLoaded() != null;
        IMessageProvider defaultMsg = isMainLoaded ? saveMessage : createMessage;
        IMessageProvider iMessageProvider = addArgMsg = isRefLoaded ? saveArgMessage : addArgMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        if (!refModel.getIsValidMessage().equals(addArgMsg)) {
            refModel.setIsValidMessage(addArgMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableAddRef = !refModel.isCleared();
        boolean enableCommit = !model.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !model.isCleared() || !refModel.isCleared();
        String name = model.getName();
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitRefButtonLabel = isRefLoaded ? buttonLabelSaveArg : buttonLabelCommitArg;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        String string = commitRefActionLabel = isRefLoaded ? actionLabelSaveArg : actionLabelCommitArg;
        if (!this.nameWidget.getText().equals(name)) {
            Point p = this.nameWidget.getSelection();
            this.nameWidget.setText(name);
            int idx = Math.min(this.nameWidget.getText().length(), p.x);
            this.nameWidget.setSelection(idx);
        }
        if (enableAddRef != this.commitRefButton.isEnabled()) {
            this.commitRefButton.setEnabled(enableAddRef);
        }
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitRefActionLabel.equals(this.commitRefAction.getText())) {
            this.commitRefAction.setText(commitRefActionLabel);
            this.commitRefAction.setToolTipText(commitRefActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!commitRefButtonLabel.equals(this.commitRefButton.getText())) {
            labelChanged = true;
            this.commitRefButton.setText(commitRefButtonLabel);
        }
        this.refViewer.getTree().setRedraw(false);
        this.refViewer.refresh();
        this.refViewer.expandAll();
        this.refViewer.getTree().setRedraw(true);
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public IReferentController getController() {
        return this.controller;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromModel();
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.refViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.refViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

