/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.helpers;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refexp.models.IRefExpModel;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.ui.controllers.IRefExpController;
import edu.mit.discourse.ui.controllers.RefExpController;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class RefExpCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = RefExpCreatorPage.class.getName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Referring Expression";
    public static String buttonLabelSaveArg = "Save Referring Expression";
    public static String actionLabelCommit = "Commit Referring Expression";
    public static String actionLabelSave = "Save Referring Expression";
    public static String actionLabelClear = "Clear Referring Expression";
    public static String actionLabelCancel = "Cancel Edit";
    public static String actionLabelCommitArg = "Commit Referring Expression";
    public static String actionLabelSaveArg = "Save Changes in Referring Expression";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new referring expression", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this referring expression to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this referring expression in the story model", 1);
    public static IMessageProvider addArgMessage = new Message("Press the 'commit reference' button to add this referring expression to the referent", 2);
    public static IMessageProvider saveArgMessage = new Message("Press the 'save referring expression' button to change this referring expression", 2);
    protected IRefExpController controller;
    protected IModelListener modelListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (RefExpCreatorPage.this.getControl().isDisposed()) {
                return;
            }
            if (e.affects(RefExpRep.getInstance()) || e.affects(RefPropRep.getInstance())) {
                RefExpCreatorPage.this.updateFromModel();
            }
        }
    };
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected SegmentSetCaptureWidget<IRefExpController> refExpWidget;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)RefExpCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.setControl((Control)control);
        this.controller = new RefExpController(this.getStoryEditor(), "edu.mit.story.ui.annotation.target1");
        this.getStoryEditor().getStoryModel().addModelListener(this.modelListener);
        this.messageManager = new MessageProviderManager();
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel());
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RefExpCreatorPage.this.updateFromModel();
            }
        });
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)this.messageBar);
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite widgets = new Composite(control, 0);
        widgets.setLayoutData((Object)new GridData(4, 128, true, false));
        widgets.setBackground(control.getBackground());
        widgets.setForeground(control.getForeground());
        widgets.setLayout((Layout)new GridLayout(2, false));
        this.createControlRefExp(widgets);
        this.createControlCommit(widgets);
        this.updateFromModel();
    }

    protected void createControlRefExp(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Referring Expression");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refExpWidget = new SegmentSetCaptureWidget(parent, 0, (ISegmentSetController)this.controller);
        this.refExpWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refExpWidget.getAddAction().setText("Add to Referring Expression");
        this.refExpWidget.getAddAction().setToolTipText("Add to Referring Expression");
        this.refExpWidget.getSubtractAction().setText("Subtract from Referring Expression");
        this.refExpWidget.getSubtractAction().setToolTipText("Subtract from Referring Expression");
        this.refExpWidget.getClearAction().setText("Clear Referring Expression");
        this.refExpWidget.getClearAction().setToolTipText("Clear Referring Expression");
    }

    protected void createControlCommit(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite buttons = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttons);
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttons.setLayout((Layout)RefExpCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        label = new Label(buttons, 0);
        label.setBackground(buttons.getBackground());
        label.setForeground(buttons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                RefExpCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                RefExpCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.refExpWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.refExpWidget.getAddAction().getActionDefinitionId(), this.refExpWidget.getAddAction());
        this.refExpWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        actionBars.setGlobalActionHandler(this.refExpWidget.getSubtractAction().getActionDefinitionId(), this.refExpWidget.getSubtractAction());
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
    }

    protected void updateFromModel() {
        String clearActionLabel;
        IMessageProvider defaultMsg;
        IRefExpModel refModel = this.controller.getModel();
        boolean isMainLoaded = refModel.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isMainLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableCommit = !refModel.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !refModel.isCleared() || !refModel.isCleared();
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String string = clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public IRefExpController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        this.getStoryEditor().getStoryModel().removeModelListener(this.modelListener);
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

