/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.handlers;

import edu.mit.discourse.core.rep.coref.Coref;
import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.refexp.RefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refexp.changes.AddRefExpChange;
import edu.mit.discourse.ui.dialogs.CorefSelectionDialog;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateRefExpHandler
extends AbstractHandler {
    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            this.setBaseEnabled(!tokens.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String tokenText;
        String message;
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!editor.getStoryModel().supports(RefExpRep.getInstance())) {
            return null;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)editor.getSelectedRange(), (IStoryData)editor.getStoryModel().getData());
        if (tokens.isEmpty()) {
            return null;
        }
        Object corefSelection = null;
        if (editor.supports(CorefRep.getInstance()) && (corefSelection = CorefSelectionDialog.open(editor, null, message = "Please select a coreference relationship to which to assign the referring expression '" + (tokenText = TextRep.getPrettyText((IHasPosition)tokens, (IStoryData)editor.getStoryModel().getData())) + "'\nPress Cancel or Escape for none", (IHasPosition)tokens)) == null) {
            return null;
        }
        RefExp refexp = new RefExp(Collections.singleton(new Segment((Collection)tokens, editor.getStoryModel().getData())));
        IHasPosition p = refexp.calculatePosition();
        long id = editor.getStoryModel().getNextID();
        Desc refexpDesc = new Desc(id, RefExpRep.getInstance(), p, (IData)refexp, null);
        refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)refexpDesc, (IMetaData)Origin.USER_SPECIFIED));
        refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)refexpDesc, (IMetaData)new Timing(start, "user")));
        AddDescriptionsChange change = new AddDescriptionsChange((IDesc)refexpDesc);
        if (corefSelection instanceof IDesc) {
            IDesc corefDesc = (IDesc)corefSelection;
            change = new CompositeModelChange(new IModelChange[]{change, new AddRefExpChange(corefDesc, (IDesc)refexpDesc, (ITiming)new Timing(start, "user"))});
        } else if (corefSelection instanceof String) {
            String name = (String)corefSelection;
            Coref coref = new Coref(name, Collections.singleton(refexpDesc));
            p = coref.calculatePosition();
            id = editor.getStoryModel().getNextID();
            Desc corefDesc = new Desc(id, CorefRep.getInstance(), p, (IData)coref, null);
            refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)corefDesc, (IMetaData)Origin.USER_SPECIFIED));
            refexpDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)corefDesc, (IMetaData)new Timing(start, "user")));
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)corefDesc)});
        }
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

