/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.dialogs;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.content.ReferentContentProvider;
import edu.mit.discourse.ui.label.ReferentLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class ReferentSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = ReferentSelectionDialog.class.getCanonicalName();
    private ReferentComparator refComparator;
    private IStoryEditor editor;
    private IStructuredContentProvider dialogCP;

    public ReferentSelectionDialog(Shell parent, IStoryEditor editor) {
        super(parent);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.dialogCP = new ReferentContentProvider(editor);
        this.setListLabelProvider((ILabelProvider)new ReferentLabelProvider(editor));
        this.setInitialPattern("?");
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ReferentFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        Object[] elements = this.dialogCP.getElements((Object)this.editor.getStoryModel());
        pm.beginTask("Searching...", elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            targetCP.add(element, itemsFilter);
            pm.worked(1);
            ++n2;
        }
        pm.done();
    }

    public String getElementName(Object item) {
        IDesc d = (IDesc)item;
        IReferent r = (IReferent)d.getData();
        return r.getName();
    }

    protected Comparator getItemsComparator() {
        if (this.refComparator == null) {
            this.refComparator = new ReferentComparator();
        }
        return this.refComparator;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DiscourseUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = DiscourseUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public static IDesc open(IStoryEditor editor) {
        return ReferentSelectionDialog.open(editor, null);
    }

    public static IDesc open(IStoryEditor editor, String title) {
        return ReferentSelectionDialog.open(editor, title, null);
    }

    public static IDesc open(IStoryEditor editor, String title, String message) {
        if (title == null) {
            title = DiscourseUIMessages.DIALOG_SelectReferent_Title;
        }
        if (message == null) {
            message = DiscourseUIMessages.DIALOG_SelectReferent_Prompt;
        }
        ReferentSelectionDialog dialog = new ReferentSelectionDialog(editor.getSite().getShell(), editor);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IDesc)result[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReferentComparator
    implements Comparator<IDesc> {
        protected ReferentComparator() {
        }

        @Override
        public int compare(IDesc d1, IDesc d2) {
            IReferent r1 = (IReferent)d1.getData();
            IReferent r2 = (IReferent)d2.getData();
            return r2.getReferences().size() - r1.getReferences().size();
        }
    }

    protected class ReferentFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ReferentFilter() {
            super((FilteredItemsSelectionDialog)ReferentSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                return this.matchDesc((IDesc)item);
            }
            return false;
        }

        protected boolean matchDesc(IDesc desc) {
            if (!ReferentRep.getInstance().isType((IHasRep)desc)) {
                return false;
            }
            IReferent ref = (IReferent)desc.getData();
            if (this.matches(ref.getName())) {
                return true;
            }
            for (IReference r : ref.getReferences()) {
                if (!this.matches(r.getDisplayText())) continue;
                return true;
            }
            return false;
        }
    }
}

