/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.dialogs;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.label.RefExpLabelProvider;
import edu.mit.story.core.desc.DescComparator;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class RefExpSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = RefExpSelectionDialog.class.getCanonicalName();
    private IStoryEditor editor;
    private ILabelProvider labelProvider;
    private IHasPosition selection = null;
    private FilterType initialFilterType = FilterType.OVERLAP;
    protected RadioButtonEnumGroup<FilterType> filterTypeGroup;

    public RefExpSelectionDialog(Shell parent, IStoryEditor editor) {
        super(parent);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.labelProvider = new RefExpLabelProvider(editor);
        this.setListLabelProvider(this.labelProvider);
        this.setInitialPattern("?");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite control = (Composite)dialogArea.getChildren()[0];
        Composite header = (Composite)control.getChildren()[0];
        this.filterTypeGroup = new RadioButtonEnumGroup(FilterType.class);
        this.filterTypeGroup.createComposite(header, 0);
        this.filterTypeGroup.setValue((Enum)this.initialFilterType);
        this.filterTypeGroup.setEnabled(this.selection != null);
        this.filterTypeGroup.setValue((Enum)this.initialFilterType);
        this.filterTypeGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefExpSelectionDialog.this.applyFilter();
            }
        });
        return dialogArea;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new RefExpFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        IDescSet ds = this.editor.getStoryModel().getData().getDescriptions(RefExpRep.getInstance());
        pm.beginTask("Searching...", ds.size());
        for (IDesc d : ds) {
            targetCP.add((Object)d, itemsFilter);
            pm.worked(1);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator getItemsComparator() {
        return DescComparator.getInstance();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DiscourseUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = DiscourseUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IHasPosition makeNearby(IHasPosition p) {
        if (p == null) {
            return null;
        }
        int offset = Math.max(0, this.selection.getOffset() - 80);
        int rightOffset = Math.min(this.editor.getStoryModel().getLength(), this.selection.getRightOffset() + 80);
        return new SimplePosition(offset, rightOffset - offset);
    }

    public static IDesc open(IStoryEditor editor) {
        return RefExpSelectionDialog.open(editor, null);
    }

    public static IDesc open(IStoryEditor editor, String title) {
        return RefExpSelectionDialog.open(editor, title, null);
    }

    public static IDesc open(IStoryEditor editor, String title, String message) {
        return RefExpSelectionDialog.open(editor, title, message, null);
    }

    public static IDesc open(IStoryEditor editor, String title, String message, IHasPosition p) {
        if (title == null) {
            title = "Select Referring Expression";
        }
        if (message == null) {
            message = "Select a referring expession";
        }
        RefExpSelectionDialog dialog = new RefExpSelectionDialog(editor.getSite().getShell(), editor);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.selection = p;
        if (p == null) {
            dialog.initialFilterType = FilterType.ALL;
        }
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IDesc)result[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilterType implements IHasName
    {
        OVERLAP("Show overlaps"),
        NEARBY("Show nearby"),
        ALL("Show all");

        private final String name;

        private FilterType(String name) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    protected class RefExpFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final FilterType filterType;
        private final IHasPosition selection;
        private final IHasPosition nearby;

        public RefExpFilter() {
            super((FilteredItemsSelectionDialog)RefExpSelectionDialog.this);
            this.filterType = RefExpSelectionDialog.this.filterTypeGroup == null ? RefExpSelectionDialog.this.initialFilterType : (FilterType)RefExpSelectionDialog.this.filterTypeGroup.getValue();
            this.selection = RefExpSelectionDialog.this.selection;
            this.nearby = RefExpSelectionDialog.this.makeNearby(RefExpSelectionDialog.this.selection);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public FilterType getType() {
            return this.filterType;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                IDesc desc = (IDesc)item;
                IRefExp refexp = (IRefExp)desc.getData();
                boolean matches = this.matches(refexp.getDisplayText());
                switch (this.filterType) {
                    case ALL: {
                        return matches;
                    }
                    case NEARBY: {
                        return matches && PositionUtils.overlaps((IHasPosition)desc, (IHasPosition)this.nearby);
                    }
                    case OVERLAP: {
                        return matches && PositionUtils.overlaps((IHasPosition)desc, (IHasPosition)this.selection);
                    }
                }
                throw new IllegalArgumentException();
            }
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            boolean patternsEqual = super.equalsFilter(filter);
            if (!patternsEqual) {
                return false;
            }
            RefExpFilter refFilter = (RefExpFilter)filter;
            return this.getType() == refFilter.getType();
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            RefExpFilter refFilter = (RefExpFilter)filter;
            if (this.filterType.ordinal() < refFilter.getType().ordinal()) {
                return false;
            }
            return super.isSubFilter(filter);
        }
    }
}

