/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.dialogs;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.label.CoreferenceLabelProvider;
import edu.mit.story.core.desc.DescComparator;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class CorefSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = CorefSelectionDialog.class.getCanonicalName();
    public static final String TEXT_WINDOW_SIZE_KEY = "TEXT_WINDOW_SIZE";
    private final IStoryEditor editor;
    private final ILabelProvider labelProvider;
    private final boolean allowNew;
    private IHasPosition selection = null;
    private FilterType initialFilterType = FilterType.NEARBY;
    private String newCorefName = null;
    protected RadioButtonEnumGroup<FilterType> filterTypeGroup;
    protected Spinner windowSizeSpinner;

    public CorefSelectionDialog(Shell parent, IStoryEditor editor, boolean allowNew) {
        super(parent);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.labelProvider = new CoreferenceLabelProvider(editor);
        this.allowNew = allowNew;
        this.setListLabelProvider(this.labelProvider);
        this.setInitialPattern("?");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite control = (Composite)dialogArea.getChildren()[0];
        Composite header = (Composite)control.getChildren()[0];
        Composite scope = new Composite(header, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        scope.setLayoutData((Object)gd);
        scope.setLayout((Layout)new GridLayout(4, false));
        this.filterTypeGroup = new RadioButtonEnumGroup(FilterType.class);
        this.filterTypeGroup.createComposite(scope, 0);
        this.filterTypeGroup.setValue((Enum)this.initialFilterType);
        this.filterTypeGroup.setEnabled(this.selection != null);
        this.filterTypeGroup.setValue((Enum)this.initialFilterType);
        this.filterTypeGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorefSelectionDialog.this.windowSizeSpinner.setEnabled(CorefSelectionDialog.this.filterTypeGroup.getValue() == FilterType.NEARBY);
                CorefSelectionDialog.this.applyFilter();
            }
        });
        Label spacer = new Label(scope, 0);
        spacer.setLayoutData((Object)new GridData(4, 0, true, false));
        this.windowSizeSpinner = new Spinner(scope, 2048);
        this.windowSizeSpinner.setMinimum(1);
        this.windowSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.windowSizeSpinner.setSelection(this.getWindowSize());
        this.windowSizeSpinner.setEnabled(this.initialFilterType == FilterType.NEARBY);
        this.windowSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int windowSize = CorefSelectionDialog.this.windowSizeSpinner.getSelection();
                CorefSelectionDialog.this.getDialogSettings().put(CorefSelectionDialog.TEXT_WINDOW_SIZE_KEY, windowSize);
                CorefSelectionDialog.this.applyFilter();
            }
        });
        Button button = new Button(scope, 8);
        button.setText("Create &New");
        button.setEnabled(this.allowNew);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorefNameInputDialog dialog = new CorefNameInputDialog();
                dialog.open();
            }
        });
        return dialogArea;
    }

    protected int getWindowSize() {
        int windowSize = 80;
        String value = this.getDialogSettings().get(TEXT_WINDOW_SIZE_KEY);
        if (value != null) {
            windowSize = Integer.parseInt(value);
        }
        return windowSize;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new CorefFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        IDescSet ds = this.editor.getStoryModel().getData().getDescriptions(CorefRep.getInstance());
        pm.beginTask("Searching...", ds.size());
        for (IDesc d : ds) {
            targetCP.add((Object)d, itemsFilter);
            pm.worked(1);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Comparator getItemsComparator() {
        return DescComparator.getInstance();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DiscourseUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = DiscourseUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public String getSelectedText() {
        if (this.selection == null) {
            return "";
        }
        return TextRep.getPrettyText((IHasPosition)this.selection, (IStoryData)this.editor.getStoryModel().getData());
    }

    protected IHasPosition makeNearby(IHasPosition p, int windowSize) {
        if (p == null) {
            return null;
        }
        if (windowSize < 1) {
            return p;
        }
        int offset = Math.max(0, this.selection.getOffset() - windowSize);
        int rightOffset = Math.min(this.editor.getStoryModel().getLength(), this.selection.getRightOffset() + windowSize);
        return new SimplePosition(offset, rightOffset - offset);
    }

    protected void computeResult() {
        if (this.newCorefName != null) {
            this.setResult(Collections.singletonList(this.newCorefName));
            return;
        }
        super.computeResult();
    }

    public static Object open(IStoryEditor editor) {
        return CorefSelectionDialog.open(editor, null);
    }

    public static Object open(IStoryEditor editor, String title) {
        return CorefSelectionDialog.open(editor, title, null);
    }

    public static Object open(IStoryEditor editor, String title, String message) {
        return CorefSelectionDialog.open(editor, title, message, null);
    }

    public static Object open(IStoryEditor editor, String title, String message, IHasPosition p) {
        return CorefSelectionDialog.open(editor, title, message, p, true);
    }

    public static Object open(IStoryEditor editor, String title, String message, IHasPosition p, boolean allowNew) {
        if (title == null) {
            title = "Select Coreference";
        }
        if (message == null) {
            message = "Select a coreference relation (? = any character, * = any string):";
        }
        CorefSelectionDialog dialog = new CorefSelectionDialog(editor.getSite().getShell(), editor, allowNew);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.selection = p;
        dialog.setInitialPattern(dialog.getSelectedText());
        if (p == null) {
            dialog.initialFilterType = FilterType.ALL;
        }
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        Object[] result = dialog.getResult();
        return result != null && result.length == 1 ? result[0] : null;
    }

    protected class CorefFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final FilterType filterType;
        private final IHasPosition selection;
        private final IHasPosition nearby;

        public CorefFilter() {
            super((FilteredItemsSelectionDialog)CorefSelectionDialog.this);
            this.filterType = CorefSelectionDialog.this.filterTypeGroup == null ? CorefSelectionDialog.this.initialFilterType : (FilterType)CorefSelectionDialog.this.filterTypeGroup.getValue();
            this.selection = CorefSelectionDialog.this.selection;
            this.nearby = CorefSelectionDialog.this.makeNearby(CorefSelectionDialog.this.selection, CorefSelectionDialog.this.getWindowSize());
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public FilterType getType() {
            return this.filterType;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                IDesc desc = (IDesc)item;
                ICoref coref = (ICoref)desc.getData();
                if (!this.matches(coref)) {
                    return false;
                }
                switch (this.filterType) {
                    case ALL: {
                        return true;
                    }
                    case NEARBY: {
                        for (IDesc refexp : coref.getReferentialExpressions()) {
                            if (!PositionUtils.overlaps((IHasPosition)refexp, (IHasPosition)this.nearby)) continue;
                            return true;
                        }
                        return false;
                    }
                    case OVERLAP: {
                        for (IDesc refexp : coref.getReferentialExpressions()) {
                            if (!PositionUtils.overlaps((IHasPosition)refexp, (IHasPosition)this.selection)) continue;
                            return true;
                        }
                        return false;
                    }
                }
                throw new IllegalArgumentException();
            }
            return false;
        }

        protected boolean matches(ICoref coref) {
            if (this.matches(coref.getName())) {
                return true;
            }
            for (IDesc refexpDesc : coref.getReferentialExpressions()) {
                IRefExp refexp = (IRefExp)refexpDesc.getData();
                if (!this.matches(refexp.getDisplayText())) continue;
                return true;
            }
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            CorefFilter refFilter = (CorefFilter)filter;
            if (!PositionUtils.positionsEqual((IHasPosition)this.nearby, (IHasPosition)refFilter.nearby)) {
                return false;
            }
            return this.getType() == refFilter.getType();
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            CorefFilter refFilter = (CorefFilter)filter;
            if (this.filterType.ordinal() < refFilter.getType().ordinal()) {
                return false;
            }
            IHasPosition combo = PositionUtils.combine((IHasPosition)refFilter.nearby, (IHasPosition)this.nearby);
            if (!PositionUtils.equalAsPositions((IHasPosition)combo, (IHasPosition)this.nearby)) {
                return false;
            }
            return super.isSubFilter(filter);
        }
    }

    public class CorefNameInputDialog
    extends InputDialog {
        public static final String title = "Coreference Name";
        public static final String message = "Type a name for the new coreference relation";

        public CorefNameInputDialog() {
            super(CorefSelectionDialog.this.getShell(), title, message, CorefSelectionDialog.this.getSelectedText(), (IInputValidator)new NonEmptyValidator());
        }

        protected void okPressed() {
            super.okPressed();
            CorefSelectionDialog.this.newCorefName = this.getValue();
            CorefSelectionDialog.this.updateStatus(Status.OK_STATUS);
            CorefSelectionDialog.this.okPressed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilterType implements IHasName
    {
        OVERLAP("Show overlaps"),
        NEARBY("Show nearby"),
        ALL("Show all");

        private final String name;

        private FilterType(String name) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class NonEmptyValidator
    implements IInputValidator {
        public String isValid(String newText) {
            return newText.trim().length() == 0 ? "Name may not be empty" : null;
        }
    }
}

