/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.controllers;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refexp.models.IRefExpModel;
import edu.mit.discourse.core.rep.refexp.models.RefExpModel;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel;
import edu.mit.discourse.ui.controllers.IRefExpController;
import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.LinkedList;

public class RefExpController
extends SegmentSetController
implements IRefExpController {
    public RefExpController(IStoryEditor editor, String refAnnoID) {
        super((ISegmentSetModel)new RefExpModel((IStoryModel)editor.getStoryModel()), editor, refAnnoID);
    }

    public IRefExpModel getModel() {
        return (IRefExpModel)super.getModel();
    }

    public void commit() {
        long id;
        IRefExpModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        LinkedList<Object> changes = new LinkedList<Object>();
        Timing editTime = new Timing(model.getStart(), "user");
        IRefExp refexp = model.create();
        IHasPosition p = refexp.calculatePosition();
        IDesc oldDesc = model.getLoaded();
        IMetaDataMap metadata = null;
        if (oldDesc == null) {
            id = this.getStoryEditor().getStoryModel().getNextID();
        } else {
            id = oldDesc.getID();
            metadata = oldDesc.getMetaData();
        }
        Desc newDesc = new Desc(id, RefExpRep.getInstance(), p, (IData)refexp, (Iterable)metadata);
        newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
        newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)editTime));
        AddDescriptionsChange change = new AddDescriptionsChange((IDesc)newDesc);
        if (oldDesc != null) {
            change = new CompositeModelChange(new IModelChange[]{new RemoveDescriptionsChange(oldDesc), change});
        }
        changes.add(change);
        for (IReferentPropertyModel propModel : model.getProperties()) {
            propModel.setReferringExpression((IDesc)newDesc);
            IReferentProperty refProp = propModel.create();
            p = refProp.calculatePosition();
            change = ChangeUtils.createModelEdit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)RefPropRep.getInstance(), (IHasPosition)p, (IData)refProp, (ITiming)editTime, (IDesc)propModel.getLoaded());
            changes.add(change);
        }
        if (oldDesc != null) {
            IRefExp oldRefexp = (IRefExp)oldDesc.getData();
            IDescSet currProps = RefPropRep.collectProperties((IRefExp)oldRefexp, (IStoryModel)this.getStoryEditor().getStoryModel());
            for (IReferentPropertyModel propModel : model.getProperties()) {
                currProps.remove((Object)propModel.getLoaded());
            }
            changes.add(new RemoveDescriptionsChange((Collection)currProps));
        }
        if (changes.size() > 1) {
            change = new CompositeModelChange(changes);
        }
        this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        this.clear();
    }

    public void edit(IDesc desc) {
        this.getModel().load(desc);
    }
}

