/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnWizardCompareMultipleResourcesWithBranchTagPage
extends SvnWizardDialogPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource[] resources;
    private UrlCombo urlCombo;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Table table;
    private TableViewer viewer;
    private SVNUrl[] urls;
    private SVNRevision revision;
    private String[] urlStrings;
    private String commonRoot;
    private CompareResource[] compareResources;
    private long revisionNumber;
    private String[] columnHeaders = new String[]{Policy.bind("SwitchDialog.resources")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};
    static /* synthetic */ Class class$0;

    public SvnWizardCompareMultipleResourcesWithBranchTagPage(IResource[] resources) {
        this("SvnWizardCompareMultipleResourcesWithBranchTagPage", resources);
    }

    public SvnWizardCompareMultipleResourcesWithBranchTagPage(String name, IResource[] resources) {
        super(name, Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.0"));
        this.resources = resources;
    }

    public SvnWizardCompareMultipleResourcesWithBranchTagPage(IResource[] resources, long revisionNumber) {
        this(resources);
        this.revisionNumber = revisionNumber;
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Policy.bind("SwitchDialog.url"));
        this.urlCombo = new UrlCombo(composite, 0);
        this.urlCombo.init(this.resources[0].getProject().getName());
        this.urlCombo.setLayoutData(new GridData(768));
        this.commonRoot = this.getCommonRoot();
        if (this.commonRoot != null) {
            this.urlCombo.setText(this.commonRoot);
        }
        this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.setPageComplete(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.canFinish());
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.getShell(), SvnWizardCompareMultipleResourcesWithBranchTagPage.this.resources[0]);
                dialog.setIncludeBranchesAndTags(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.resources.length == 1);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    SvnWizardCompareMultipleResourcesWithBranchTagPage.this.urlCombo.setText(dialog.getUrl());
                    SvnWizardCompareMultipleResourcesWithBranchTagPage.this.setPageComplete(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.canFinish());
                }
            }
        });
        Composite revisionGroup = new Composite(composite, 0);
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionLayout.marginWidth = 0;
        revisionLayout.marginHeight = 0;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button(revisionGroup, 32);
        this.headButton.setText(Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.1"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        Label revisionLabel = new Label(revisionGroup, 0);
        revisionLabel.setText(Policy.bind("SvnWizardSwitchPage.revision"));
        this.revisionText = new Text(revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.headButton.setSelection(true);
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.setPageComplete(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.canFinish());
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener((FocusListener)focusListener);
        this.logButton = new Button(revisionGroup, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        this.logButton.setEnabled(false);
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.showLog();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.revisionText.setEnabled(!SvnWizardCompareMultipleResourcesWithBranchTagPage.this.headButton.getSelection());
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.logButton.setEnabled(!SvnWizardCompareMultipleResourcesWithBranchTagPage.this.headButton.getSelection());
                SvnWizardCompareMultipleResourcesWithBranchTagPage.this.setPageComplete(SvnWizardCompareMultipleResourcesWithBranchTagPage.this.canFinish());
                if (!SvnWizardCompareMultipleResourcesWithBranchTagPage.this.headButton.getSelection()) {
                    SvnWizardCompareMultipleResourcesWithBranchTagPage.this.revisionText.selectAll();
                    SvnWizardCompareMultipleResourcesWithBranchTagPage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)listener);
        if (this.resources.length > 1) {
            this.table = new Table(composite, 2816);
            this.table.setLinesVisible(false);
            this.table.setHeaderVisible(true);
            data = new GridData(1808);
            data.horizontalSpan = 3;
            this.table.setLayoutData((Object)data);
            TableLayout tableLayout = new TableLayout();
            this.table.setLayout((Layout)tableLayout);
            this.viewer = new TableViewer(this.table);
            this.viewer.setContentProvider((IContentProvider)new CompareContentProvider());
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.viewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new CompareLabelProvider(), decorator));
            int i = 0;
            while (i < this.columnHeaders.length) {
                tableLayout.addColumnData(this.columnLayouts[i]);
                TableColumn tc = new TableColumn(this.table, 0, i);
                tc.setResizable(this.columnLayouts[i].resizable);
                tc.setText(this.columnHeaders[i]);
                ++i;
            }
            this.viewer.setInput((Object)this);
            this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardCompareMultipleResourcesWithBranchTagPage.this.viewer.refresh();
                }
            });
        }
        this.setPageComplete(this.canFinish());
    }

    public String getWindowTitle() {
        return Policy.bind(Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.0"));
    }

    public boolean performCancel() {
        return true;
    }

    protected void showLog() {
        ISVNRemoteFile remoteResource = null;
        try {
            remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]).getRepository().getRemoteFile(new SVNUrl(this.urlCombo.getText()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
            return;
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.urlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    public boolean performFinish() {
        block8: {
            this.urlCombo.saveUrl();
            try {
                if (this.urlStrings.length > 1) {
                    this.urls = new SVNUrl[this.compareResources.length];
                    int i = 0;
                    while (i < this.compareResources.length) {
                        this.urls[i] = this.urlCombo.getText().endsWith("/") ? new SVNUrl(String.valueOf(this.urlCombo.getText()) + this.compareResources[i].getPartialPath()) : new SVNUrl(String.valueOf(this.urlCombo.getText()) + "/" + this.compareResources[i].getPartialPath());
                        ++i;
                    }
                } else {
                    this.urls = new SVNUrl[1];
                    this.urls[0] = new SVNUrl(this.urlCombo.getText());
                }
                if (this.headButton.getSelection()) {
                    this.revision = SVNRevision.HEAD;
                    break block8;
                }
                try {
                    this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.0"), (String)Policy.bind("SwitchDialog.invalid"));
                    return false;
                }
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.0"), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void saveSettings() {
    }

    public void setMessage() {
        this.setMessage(Policy.bind("SvnWizardCompareMultipleResourcesWithBranchTagPage.8"));
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        return this.urlCombo.getText().length() > 0 && (this.headButton.getSelection() || this.revisionText.getText().trim().length() > 0);
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNUrl[] getUrls() {
        return this.urls;
    }

    private String getCommonRoot() {
        ArrayList<String> urlList = new ArrayList<String>();
        int i = 0;
        while (i < this.resources.length) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
            try {
                String anUrl = svnResource.getStatus().getUrlString();
                if (anUrl != null) {
                    urlList.add(anUrl);
                }
            }
            catch (SVNException sVNException) {}
            ++i;
        }
        this.urlStrings = new String[urlList.size()];
        urlList.toArray(this.urlStrings);
        if (this.urlStrings.length == 0) {
            return null;
        }
        String urlString = this.urlStrings[0];
        if (this.urlStrings.length == 1) {
            return urlString;
        }
        String commonRoot = null;
        int i2 = 0;
        block3: while (i2 < urlString.length()) {
            String partialPath = urlString.substring(0, i2 + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < this.urlStrings.length) {
                    if (!this.urlStrings[j].startsWith(partialPath)) break block3;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i2);
            }
            ++i2;
        }
        this.compareResources = new CompareResource[this.resources.length];
        i2 = 0;
        while (i2 < this.resources.length) {
            this.compareResources[i2] = new CompareResource(this.resources[i2], this.urlStrings[i2].substring(commonRoot.length() + 1));
            ++i2;
        }
        return commonRoot;
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    private class CompareResource
    implements IAdaptable {
        private IResource resource;
        private String partialPath;

        public CompareResource(IResource resource, String partialPath) {
            this.resource = resource;
            this.partialPath = partialPath;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public void setPartialPath(String partialPath) {
            this.partialPath = partialPath;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == adapter) {
                return this.resource;
            }
            return null;
        }
    }

    class CompareLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        CompareLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public String getText(Object element) {
            CompareResource compareResource = (CompareResource)element;
            return String.valueOf(compareResource.getPartialPath()) + " [" + SvnWizardCompareMultipleResourcesWithBranchTagPage.this.urlCombo.getText() + "/" + compareResource.getPartialPath() + "]";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Image getImage(Object element) {
            CompareResource compareResource = (CompareResource)element;
            return this.workbenchLabelProvider.getImage((Object)compareResource.getResource());
        }
    }

    class CompareContentProvider
    implements IStructuredContentProvider {
        CompareContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return SvnWizardCompareMultipleResourcesWithBranchTagPage.this.compareResources;
        }
    }

    class TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        ITableLabelProvider provider;
        ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (ITableLabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getColumnImage(element, columnIndex);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = this.provider.getColumnText(element, columnIndex);
            return text;
        }
    }
}

