/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalBaseCompareInput;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareSummaryInput;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public abstract class CompareWithRemoteAction
extends WorkbenchWindowAction {
    private final SVNRevision revision;
    private boolean refresh;
    private boolean fileSelected;

    public CompareWithRemoteAction(SVNRevision revision) {
        this.revision = revision;
    }

    public void execute(IAction action) {
        this.refresh = false;
        this.fileSelected = false;
        final IResource[] resources = this.getSelectedResources();
        if (resources.length != 1 && !SVNRevision.BASE.equals((Object)this.revision) && !SVNRevision.HEAD.equals((Object)this.revision)) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFile) {
                this.fileSelected = true;
                if (!resources[i].isSynchronized(2)) {
                    this.refresh = MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)Policy.bind("CompareWithRemoteAction.fileChanged"));
                    break;
                }
            }
            ++i;
        }
        try {
            final ISVNLocalResource[] localResources = new ISVNLocalResource[resources.length];
            int i2 = 0;
            while (i2 < resources.length) {
                localResources[i2] = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i2]);
                ++i2;
            }
            final ISVNLocalResource localResource = localResources[0];
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        if (CompareWithRemoteAction.this.refresh) {
                            int i = 0;
                            while (i < localResources.length) {
                                if (resources[i] instanceof IFile) {
                                    localResources[i].getResource().refreshLocal(2, monitor);
                                }
                                ++i;
                            }
                        }
                        if (SVNRevision.BASE.equals((Object)CompareWithRemoteAction.this.revision)) {
                            if (localResources.length == 1 && localResource.getResource() instanceof IFile) {
                                SVNLocalCompareInput compareInput = new SVNLocalCompareInput(localResource, CompareWithRemoteAction.this.revision);
                                CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                            } else {
                                SVNLocalBaseCompareInput compareInput = new SVNLocalBaseCompareInput(localResources, CompareWithRemoteAction.this.revision);
                                CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                            }
                        } else if (!CompareWithRemoteAction.this.fileSelected) {
                            SVNLocalCompareSummaryInput compareInput = new SVNLocalCompareSummaryInput(localResources, CompareWithRemoteAction.this.revision);
                            CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                        } else {
                            RemoteFile remoteFile = new RemoteFile(localResource.getRepository(), localResource.getUrl(), CompareWithRemoteAction.this.revision);
                            remoteFile.setPegRevision(CompareWithRemoteAction.this.revision);
                            SVNLocalCompareInput compareInput = new SVNLocalCompareInput(localResource, (ISVNRemoteResource)remoteFile);
                            ShowDifferencesAsUnifiedDiffOperationWC operation = null;
                            if (SVNRevision.HEAD.equals((Object)CompareWithRemoteAction.this.revision)) {
                                File file = File.createTempFile("revision", ".diff");
                                file.deleteOnExit();
                                operation = new ShowDifferencesAsUnifiedDiffOperationWC(CompareWithRemoteAction.this.getTargetPart(), localResource.getFile(), localResource.getUrl(), SVNRevision.HEAD, file);
                                operation.setGraphicalCompare(true);
                                operation.run();
                            }
                            compareInput.setDiffOperation(operation);
                            CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                        }
                    }
                    catch (Exception e) {
                        CompareWithRemoteAction.this.handle(e, null, null);
                    }
                }
            }, false, 2);
        }
        catch (Exception e) {
            this.handle(e, null, null);
        }
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) throws SVNException {
        if (svnResource.getResource() == null || !svnResource.getResource().exists()) {
            return false;
        }
        return super.isEnabledForSVNResource(svnResource) || svnResource.getParent().isManaged();
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    protected boolean isEnabledForMultipleResources() {
        return SVNRevision.BASE.equals((Object)this.revision) || SVNRevision.HEAD.equals((Object)this.revision);
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

