/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.EclipseVersion;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;

public class FileUtils {
    public static String getEclipseRealLocation(Manipulator manipulator, String location) {
        if (location.indexOf(":") >= 0) {
            return location;
        }
        LauncherData launcherData = manipulator.getLauncherData();
        File home = launcherData.getHome();
        File pluginsDir = null;
        if (home != null) {
            pluginsDir = new File(home, "plugins");
        } else if (launcherData.getLauncher() != null) {
            pluginsDir = new File(launcherData.getLauncher().getParentFile(), "plugins");
        } else if (launcherData.getFwJar() != null) {
            pluginsDir = launcherData.getFwJar().getParentFile();
        }
        String pluginName = FileUtils.getPluginName(location);
        String ret = FileUtils.getEclipsePluginFullLocation(pluginName, pluginsDir);
        return ret;
    }

    private static String getPluginName(String location) {
        int position = location.indexOf("_");
        String pluginName = location;
        if (position >= 0) {
            pluginName = location.substring(0, position);
        }
        return pluginName;
    }

    public static String getRealLocation(Manipulator manipulator, String location, boolean useEclipse) {
        if (location == null) {
            return null;
        }
        String ret = location;
        if (location.startsWith("reference:") && (ret = location.substring("reference:".length())).endsWith(".jar/") && (ret = ret.substring(0, ret.length() - "/".length())).startsWith("file:")) {
            ret = ret.substring("file:".length());
        }
        if (location.startsWith("initial@")) {
            ret = location.substring("initial@".length());
        }
        if (ret == location) {
            return useEclipse ? FileUtils.getEclipseRealLocation(manipulator, location) : location;
        }
        return FileUtils.getRealLocation(manipulator, ret, useEclipse);
    }

    private static String replaceAll(String st, String oldSt, String newSt) {
        if (oldSt.equals(newSt)) {
            return st;
        }
        int index = -1;
        while ((index = st.indexOf(oldSt)) != -1) {
            st = String.valueOf(st.substring(0, index)) + newSt + st.substring(index + oldSt.length());
        }
        return st;
    }

    private static String getEclipseNamingVersion(URL url, String pluginName, boolean isFile) {
        String location = url.getFile();
        location = FileUtils.replaceAll(location, File.separator, "/");
        String filename = null;
        filename = location.indexOf(":") == -1 ? location : location.substring(location.lastIndexOf(":") + 1);
        if (isFile) {
            if (!filename.endsWith(".jar")) {
                return null;
            }
            filename = filename.substring(0, filename.lastIndexOf(".jar"));
        } else {
            filename = filename.substring(0, filename.length() - 1);
        }
        if (filename.indexOf("/") != -1) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        }
        if (!filename.startsWith(pluginName)) {
            return null;
        }
        int pluginnameLength = pluginName.length();
        if (filename.length() <= pluginnameLength || filename.charAt(pluginName.length()) != '_') {
            return null;
        }
        return filename.substring(pluginnameLength + 1);
    }

    public static String getEclipsePluginFullLocation(String pluginName, File bundlesDir) {
        File[] lists = bundlesDir.listFiles();
        URL ret = null;
        EclipseVersion maxVersion = null;
        if (lists == null) {
            return null;
        }
        int i = 0;
        while (i < lists.length) {
            try {
                URL url = lists[i].toURL();
                String version = FileUtils.getEclipseNamingVersion(url, pluginName, lists[i].isFile());
                if (version != null) {
                    EclipseVersion eclipseVersion = new EclipseVersion(version);
                    if (maxVersion == null || eclipseVersion.compareTo(maxVersion) > 0) {
                        ret = url;
                        maxVersion = eclipseVersion;
                    }
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
            ++i;
        }
        return ret == null ? null : ret.toExternalForm();
    }
}

