/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.util.NLS;

public class MirrorRequest
extends ArtifactRequest {
    private static final ProcessingStepDescriptor[] EMPTY_STEPS = new ProcessingStepDescriptor[0];
    private final IArtifactRepository target;
    private final Properties targetDescriptorProperties;
    private final Properties targetRepositoryProperties;

    public MirrorRequest(IArtifactKey key, IArtifactRepository targetRepository, Properties targetDescriptorProperties, Properties targetRepositoryProperties) {
        super(key);
        this.target = targetRepository;
        if (targetDescriptorProperties == null || targetDescriptorProperties.isEmpty()) {
            this.targetDescriptorProperties = null;
        } else {
            this.targetDescriptorProperties = new Properties();
            this.targetDescriptorProperties.putAll((Map<?, ?>)targetDescriptorProperties);
        }
        if (targetRepositoryProperties == null || targetRepositoryProperties.isEmpty()) {
            this.targetRepositoryProperties = null;
        } else {
            this.targetRepositoryProperties = new Properties();
            this.targetRepositoryProperties.putAll((Map<?, ?>)targetRepositoryProperties);
        }
    }

    public void perform(IProgressMonitor monitor) {
        IArtifactDescriptor[] descriptors;
        monitor.subTask(NLS.bind((String)Messages.downloading, (Object)this.getArtifactKey().getId()));
        if (this.target.contains(this.getArtifactKey())) {
            this.setResult((IStatus)new Status(0, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.available_already_in, (Object)this.getArtifactKey())));
            return;
        }
        IArtifactDescriptor optimized = null;
        IArtifactDescriptor canonical = null;
        if (this.descriptor == null && (descriptors = this.source.getArtifactDescriptors(this.getArtifactKey())).length > 0) {
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getProperty("format") == null) {
                    canonical = descriptors[i];
                } else if (ProcessingStepHandler.canProcess(descriptors[i])) {
                    optimized = descriptors[i];
                }
                ++i;
            }
            boolean chooseCanonical = this.source.getLocation().getProtocol().equals("file");
            IArtifactDescriptor iArtifactDescriptor = this.descriptor = chooseCanonical ? canonical : optimized;
            if (this.descriptor == null) {
                IArtifactDescriptor iArtifactDescriptor2 = this.descriptor = !chooseCanonical ? canonical : optimized;
            }
        }
        if (this.descriptor == null) {
            this.setResult((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)this.getArtifactKey())));
            return;
        }
        ArtifactDescriptor destinationDescriptor = this.getDestinationDescriptor(this.descriptor);
        IStatus status = this.transfer(destinationDescriptor, this.descriptor, monitor);
        if (status.getSeverity() == 8) {
            this.setResult(status);
            return;
        }
        if (monitor.isCanceled()) {
            this.setResult(Status.CANCEL_STATUS);
            return;
        }
        if (status.isOK()) {
            this.setResult(status);
            return;
        }
        if (this.target.contains(destinationDescriptor)) {
            this.target.removeDescriptor(destinationDescriptor);
        }
        if (this.descriptor == canonical || canonical == null) {
            this.setResult(status);
            return;
        }
        this.setResult(this.transfer(this.getDestinationDescriptor(canonical), canonical, monitor));
    }

    private ArtifactDescriptor getDestinationDescriptor(IArtifactDescriptor sourceDescriptor) {
        ArtifactDescriptor destinationDescriptor = new ArtifactDescriptor(sourceDescriptor);
        destinationDescriptor.setProcessingSteps(EMPTY_STEPS);
        destinationDescriptor.setProperty("download.md5", null);
        destinationDescriptor.setProperty("download.contentType", null);
        destinationDescriptor.setProperty("format", null);
        if (this.targetDescriptorProperties != null) {
            destinationDescriptor.addProperties(this.targetDescriptorProperties);
        }
        if (this.targetRepositoryProperties != null) {
            destinationDescriptor.addRepositoryProperties(this.targetRepositoryProperties);
        }
        return destinationDescriptor;
    }

    private IStatus transfer(IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        while ((status = this.transferSingle(destinationDescriptor, sourceDescriptor, monitor)).getSeverity() == 4 && status.getCode() == 13) {
        }
        return status;
    }

    private IStatus transferSingle(IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        OutputStream destination;
        try {
            destination = this.target.getOutputStream(destinationDescriptor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        Object status = null;
        try {
            status = this.getSourceRepository().getArtifact(sourceDescriptor, destination, monitor);
        }
        catch (Throwable throwable) {
            try {
                destination.close();
            }
            catch (IOException e) {
                status = status != null && status.getSeverity() == 4 && status.getCode() == 13 ? new MultiStatus("org.eclipse.equinox.p2.artifact.repository", status.getCode(), new IStatus[]{status}, NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e) : new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            destination.close();
        }
        catch (IOException e) {
            status = status != null && status.getSeverity() == 4 && status.getCode() == 13 ? new MultiStatus("org.eclipse.equinox.p2.artifact.repository", status.getCode(), new IStatus[]{status}, NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e) : new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
        }
        return status;
    }

    public String toString() {
        return String.valueOf(Messages.mirroring) + this.getArtifactKey() + " into " + this.target;
    }
}

