/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Timing {
    private long start;
    private static long startTime = System.currentTimeMillis();
    private NumberFormat nf = new DecimalFormat("0.0");

    public Timing() {
        this.start();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public long report() {
        return System.currentTimeMillis() - this.start;
    }

    public long report(String str, PrintStream stream) {
        long elapsed = this.report();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public long report(String str) {
        return this.report(str, System.err);
    }

    public long report(String str, PrintWriter writer) {
        long elapsed = this.report();
        writer.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public String toSecondsString() {
        long elapsed = this.report();
        return this.nf.format((double)elapsed / 1000.0);
    }

    public long restart() {
        long elapsed = this.report();
        this.start();
        return elapsed;
    }

    public long restart(String str, PrintStream stream) {
        long elapsed = this.report(str, stream);
        this.start();
        return elapsed;
    }

    public long restart(String str) {
        return this.restart(str, System.err);
    }

    public long restart(String str, PrintWriter writer) {
        long elapsed = this.report(str, writer);
        this.start();
        return elapsed;
    }

    public long stop() {
        long elapsed = this.report();
        this.start = 0L;
        return elapsed;
    }

    public long stop(String str, PrintStream stream) {
        this.report(str, stream);
        return this.stop();
    }

    public long stop(String str) {
        return this.stop(str, System.err);
    }

    public long stop(String str, PrintWriter writer) {
        this.report(str, writer);
        return this.stop();
    }

    public static void startTime() {
        startTime = System.currentTimeMillis();
    }

    public static long endTime() {
        return System.currentTimeMillis() - startTime;
    }

    public static long endTime(String str, PrintStream stream) {
        long elapsed = Timing.endTime();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long endTime(String str) {
        return Timing.endTime(str, System.err);
    }

    public static long tick() {
        long elapsed = System.currentTimeMillis() - startTime;
        Timing.startTime();
        return elapsed;
    }

    public static long tick(String str, PrintStream stream) {
        long elapsed = Timing.tick();
        stream.println(str + " Time elapsed: " + elapsed + " ms");
        return elapsed;
    }

    public static long tick(String str) {
        return Timing.tick(str, System.err);
    }

    public String toString() {
        return "Timing[start=" + startTime + "]";
    }
}

